/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.scripting;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyShell;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import groovy.transform.CompileStatic;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public final class ScriptingUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingUtils.class);
    private static final CompilerConfiguration GROOVY_COMPILER_CONFIG = new CompilerConfiguration();
    private static final String INLINE_PATTERN = "%s\\s*\\{\\s*(.+)\\s*\\}";
    private static final String FILE_PATTERN = "(file|classpath):(.+\\.%s)";
    private static final Pattern INLINE_GROOVY_PATTERN;
    private static final Pattern FILE_GROOVY_PATTERN;

    public static boolean isInlineGroovyScript(String script) {
        return ScriptingUtils.getMatcherForInlineGroovyScript(script).find();
    }

    public static boolean isExternalGroovyScript(String script) {
        return ScriptingUtils.getMatcherForExternalGroovyScript(script).find();
    }

    public static Matcher getMatcherForInlineGroovyScript(String script) {
        return INLINE_GROOVY_PATTERN.matcher(script);
    }

    public static Matcher getMatcherForExternalGroovyScript(String script) {
        return FILE_GROOVY_PATTERN.matcher(script);
    }

    public static <T> T executeGroovyShellScript(Script script, Class<T> clazz) {
        return ScriptingUtils.executeGroovyShellScript(script, new HashMap<String, Object>(0), clazz);
    }

    public static <T> T executeGroovyShellScript(Script script, Map<String, Object> variables, Class<T> clazz) {
        try {
            Binding binding = script.getBinding();
            if (!binding.hasVariable("logger")) {
                binding.setVariable("logger", (Object)LOGGER);
            }
            if (variables != null && !variables.isEmpty()) {
                variables.forEach((arg_0, arg_1) -> ((Binding)binding).setVariable(arg_0, arg_1));
            }
            script.setBinding(binding);
            LOGGER.debug("Executing groovy script [{}] with variables [{}]", (Object)script, (Object)binding.getVariables());
            Object result = script.run();
            return ScriptingUtils.getGroovyScriptExecutionResultOrThrow(clazz, result);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    public static <T> T executeGroovyScript(Resource groovyScript, Object[] args, Class<T> clazz, boolean failOnError) {
        return (T)FunctionUtils.doUnchecked(() -> ScriptingUtils.executeGroovyScript(groovyScript, "run", args, clazz, failOnError));
    }

    public static <T> T executeGroovyScript(GroovyObject groovyObject, Object[] args, Class<T> clazz, boolean failOnError) throws Throwable {
        return ScriptingUtils.executeGroovyScript(groovyObject, "run", args, clazz, failOnError);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Class<T> clazz, Object ... args) {
        return ScriptingUtils.executeGroovyScript(groovyScript, methodName, args, clazz, false);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Class<T> clazz) {
        return ScriptingUtils.executeGroovyScript(groovyScript, methodName, ArrayUtils.EMPTY_OBJECT_ARRAY, clazz, false);
    }

    public static <T> T executeGroovyScript(Resource groovyScript, String methodName, Object[] args, Class<T> clazz, boolean failOnError) {
        try {
            if (groovyScript == null || StringUtils.isBlank((CharSequence)methodName)) {
                return null;
            }
            return ScriptingUtils.getGroovyResult(groovyScript, methodName, args, clazz, failOnError);
        }
        catch (Throwable e) {
            if (failOnError) {
                throw new RuntimeException(e);
            }
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    public static <T> T executeGroovyScript(GroovyObject groovyObject, String methodName, Object[] args, Class<T> clazz, boolean failOnError) throws Throwable {
        try {
            LOGGER.trace("Executing groovy script's [{}] method, with parameters [{}]", (Object)methodName, (Object)args);
            Object result = groovyObject.invokeMethod(methodName, (Object)args);
            LOGGER.trace("Results returned by the groovy script are [{}]", result);
            if (!clazz.equals(Void.class)) {
                return ScriptingUtils.getGroovyScriptExecutionResultOrThrow(clazz, result);
            }
        }
        catch (Throwable throwable) {
            Throwable cause;
            Throwable throwable2 = cause = throwable instanceof InvokerInvocationException ? throwable.getCause() : throwable;
            if (failOnError) {
                throw cause;
            }
            if (cause instanceof MissingMethodException) {
                LOGGER.debug(cause.getMessage(), cause);
            }
            LoggingUtils.error((Logger)LOGGER, (Throwable)cause);
        }
        return null;
    }

    public static Script parseGroovyShellScript(Map inputVariables, String script) {
        HashMap<String, Logger> variables = inputVariables != null ? new HashMap<String, Logger>(inputVariables) : new HashMap();
        variables.putIfAbsent("logger", LOGGER);
        Binding binding = new Binding(variables);
        GroovyShell shell = new GroovyShell(binding, GROOVY_COMPILER_CONFIG);
        LOGGER.debug("Parsing groovy script [{}]", (Object)script);
        return shell.parse(script, binding);
    }

    public static Script parseGroovyShellScript(String script) {
        return StringUtils.isNotBlank((CharSequence)script) ? ScriptingUtils.parseGroovyShellScript(Map.of(), script) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GroovyObject parseGroovyScript(Resource groovyScript, boolean failOnError) {
        try (GroovyClassLoader loader = ScriptingUtils.newGroovyClassLoader();){
            Class groovyClass = ScriptingUtils.loadGroovyClass(groovyScript, loader);
            if (groovyClass != null) {
                LOGGER.trace("Creating groovy object instance from class [{}]", (Object)groovyScript.getURI().getPath());
                GroovyObject groovyObject = (GroovyObject)groovyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return groovyObject;
            }
            LOGGER.warn("Groovy script at [{}] does not exist", (Object)groovyScript.getURI().getPath());
            return null;
        }
        catch (Exception e) {
            if (failOnError) {
                throw new RuntimeException(e);
            }
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return null;
    }

    public static GroovyClassLoader newGroovyClassLoader() {
        return new GroovyClassLoader(ScriptingUtils.class.getClassLoader(), GROOVY_COMPILER_CONFIG);
    }

    private static Class loadGroovyClass(Resource groovyScript, GroovyClassLoader loader) throws IOException {
        if (ResourceUtils.isJarResource((Resource)groovyScript)) {
            try (BufferedReader groovyReader = new BufferedReader(new InputStreamReader(groovyScript.getInputStream(), StandardCharsets.UTF_8));){
                Class clazz = loader.parseClass((Reader)groovyReader, groovyScript.getFilename());
                return clazz;
            }
        }
        File groovyFile = groovyScript.getFile();
        if (groovyFile.exists()) {
            return loader.parseClass(groovyFile);
        }
        return null;
    }

    private static <T> T getGroovyResult(Resource groovyScript, String methodName, Object[] args, Class<T> clazz, boolean failOnError) throws Throwable {
        try {
            GroovyObject groovyObject = ScriptingUtils.parseGroovyScript(groovyScript, failOnError);
            if (groovyObject == null) {
                LOGGER.error("Could not parse the Groovy script at [{}]", (Object)groovyScript);
                return null;
            }
            return ScriptingUtils.executeGroovyScript(groovyObject, methodName, args, clazz, failOnError);
        }
        catch (Throwable e) {
            if (failOnError) {
                throw e;
            }
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    private static <T> T getGroovyScriptExecutionResultOrThrow(Class<T> clazz, Object result) {
        if (result != null && !clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + String.valueOf(result) + " is of type " + String.valueOf(result.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getObjectInstanceFromGroovyResource(Resource resource, Class[] constructorArgs, Object[] args, Class<T> expectedType) {
        try {
            if (resource == null) {
                LOGGER.debug("No groovy script is defined");
                return null;
            }
            String script = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
            try (GroovyClassLoader classLoader = ScriptingUtils.newGroovyClassLoader();){
                Class clazz = classLoader.parseClass(script);
                LOGGER.trace("Preparing constructor arguments [{}] for resource [{}]", (Object)args, (Object)resource);
                Constructor ctor = clazz.getDeclaredConstructor(constructorArgs);
                Object result = ctor.newInstance(args);
                if (!expectedType.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException("Result [" + String.valueOf(result) + " is of type " + String.valueOf(result.getClass()) + " when we were expecting " + String.valueOf(expectedType));
                }
                Object t = result;
                return t;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    @Generated
    private ScriptingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        boolean isStaticCompilation = BooleanUtils.toBoolean((String)System.getProperty("org.apereo.cas.groovy.compile.static"));
        if (CasRuntimeHintsRegistrar.inNativeImage() || isStaticCompilation) {
            GROOVY_COMPILER_CONFIG.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(CompileStatic.class)});
        }
        ImportCustomizer imports = new ImportCustomizer();
        imports.addStarImports(new String[]{"java.time", "java.util", "java.util.function", "java.io", "java.math", "java.beans", "java.net", "java.nio", "java.nio.charset", "java.util.stream", "groovy.net", "groovy.json", "groovy.text", "groovy.util", "groovy.lang", "groovy.transform", "org.slf4j", "org.apache.http", "org.apache.http.util", "org.apache.http.client.methods", "org.apache.http.impl.client", "org.apache.commons.lang3", "org.apache.commons.text", "org.apache.commons.io", "org.apache.commons.io.output", "org.apache.commons.codec.binary", "org.apache.commons.codec.digest", "org.apereo.inspektr.common.web", "jakarta.servlet", "jakarta.servlet.http", "org.ldaptive", "org.jose4j.jwk", "org.springframework.context", "org.springframework.core", "org.springframework.core.io", "org.springframework.webflow", "org.springframework.webflow.execution", "org.springframework.webflow.action", "org.opensaml.core.xml", "org.opensaml.saml.metadata.resolver", "org.opensaml.saml.saml2.core", "org.opensaml.saml.saml2.binding", "org.opensaml.saml.metadata.resolver", "org.opensaml.saml.common", "org.apereo.cas", "org.apereo.cas.api", "org.apereo.cas.audit", "org.apereo.cas.authentication", "org.apereo.cas.authentication.services", "org.apereo.cas.authentication.credential", "org.apereo.cas.authentication.principal", "org.apereo.cas.configuration.support", "org.apereo.cas.util", "org.apereo.cas.util.model", "org.apereo.cas.web", "org.apereo.cas.web.support", "org.apereo.cas.authentication.mfa", "org.apereo.cas.services", "org.apereo.cas.heimdall", "org.apereo.cas.heimdall.authorizer", "org.apereo.cas.support.saml", "org.apereo.cas.support.saml.services"});
        GROOVY_COMPILER_CONFIG.addCompilationCustomizers(new CompilationCustomizer[]{imports});
        INLINE_GROOVY_PATTERN = RegexUtils.createPattern((String)String.format(INLINE_PATTERN, "groovy"), (int)40);
        FILE_GROOVY_PATTERN = RegexUtils.createPattern((String)String.format(FILE_PATTERN, "groovy"));
    }
}

