/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.AcquiredExternalWorkerJob;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.AcquiredExternalWorkerJobImpl;
import org.flowable.job.service.impl.ExternalWorkerJobAcquireBuilderImpl;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;

public class AcquireExternalWorkerJobsCmd
implements Command<List<AcquiredExternalWorkerJob>> {
    protected final String workerId;
    protected final int numberOfJobs;
    protected final ExternalWorkerJobAcquireBuilderImpl builder;
    protected final JobServiceConfiguration jobServiceConfiguration;

    public AcquireExternalWorkerJobsCmd(String workerId, int numberOfJobs, ExternalWorkerJobAcquireBuilderImpl builder, JobServiceConfiguration jobServiceConfiguration) {
        this.workerId = workerId;
        this.numberOfJobs = numberOfJobs;
        this.builder = builder;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public List<AcquiredExternalWorkerJob> execute(CommandContext commandContext) {
        String topic = this.builder.getTopic();
        if (StringUtils.isEmpty((CharSequence)topic)) {
            throw new FlowableIllegalArgumentException("topic must not be empty");
        }
        if (this.numberOfJobs < 1) {
            throw new FlowableIllegalArgumentException("requested number of jobs must not be smaller than 1");
        }
        if (StringUtils.isEmpty((CharSequence)this.workerId)) {
            throw new FlowableIllegalArgumentException("workerId must not be empty");
        }
        ExternalWorkerJobEntityManager externalWorkerJobEntityManager = this.jobServiceConfiguration.getExternalWorkerJobEntityManager();
        InternalJobManager internalJobManager = this.jobServiceConfiguration.getInternalJobManager();
        List<ExternalWorkerJobEntity> jobs = externalWorkerJobEntityManager.findExternalJobsToExecute(this.builder, this.numberOfJobs);
        int lockTimeInMillis = (int)this.builder.getLockDuration().abs().toMillis();
        ArrayList<AcquiredExternalWorkerJob> acquiredJobs = new ArrayList<AcquiredExternalWorkerJob>(jobs.size());
        for (ExternalWorkerJobEntity job : jobs) {
            this.lockJob(commandContext, job, lockTimeInMillis);
            Map<String, Object> variables = null;
            if (internalJobManager != null) {
                variables = internalJobManager.resolveVariablesForExternalWorkerJob(job);
                if (job.isExclusive()) {
                    internalJobManager.lockJobScope(job);
                }
            }
            acquiredJobs.add(new AcquiredExternalWorkerJobImpl(job, variables));
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, JobInfoEntity job, int lockTimeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.jobServiceConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockOwner(this.workerId);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

