/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.calendar;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.calendar.AdvancedSchedulerResolver;
import org.flowable.common.engine.impl.calendar.CronExpression;
import org.flowable.common.engine.impl.calendar.DurationHelper;
import org.flowable.common.engine.impl.runtime.ClockReader;

public class AdvancedSchedulerResolverWithTimeZone
implements AdvancedSchedulerResolver {
    @Override
    public Date resolve(String duedateDescription, ClockReader clockReader, TimeZone timeZone) {
        Calendar nextRun = null;
        try {
            if (duedateDescription.startsWith("R")) {
                nextRun = new DurationHelper(duedateDescription, clockReader).getCalendarAfter(clockReader.getCurrentCalendar(timeZone));
            } else {
                CronExpression cronExpression = new CronExpression(duedateDescription, clockReader);
                cronExpression.setTimeZone(timeZone);
                Date nextRunDate = cronExpression.getTimeAfter(clockReader.getCurrentCalendar(timeZone).getTime());
                nextRun = new GregorianCalendar();
                nextRun.setTime(nextRunDate);
            }
        }
        catch (Exception e) {
            throw new FlowableException("Failed to parse scheduler expression: " + duedateDescription, (Throwable)e);
        }
        return nextRun == null ? null : nextRun.getTime();
    }
}

