/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.interceptor;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.UndeclaredThrowableException;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaTransactionInterceptor
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JtaTransactionInterceptor.class);
    private final TransactionManager transactionManager;

    public JtaTransactionInterceptor(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command, CommandExecutor commandExecutor) {
        T t;
        LOGGER.debug("Running command with propagation {}", (Object)config.getTransactionPropagation());
        if (config.getTransactionPropagation() == TransactionPropagation.NOT_SUPPORTED) {
            return this.next.execute(config, command, commandExecutor);
        }
        boolean requiresNew = config.getTransactionPropagation() == TransactionPropagation.REQUIRES_NEW;
        Transaction oldTx = null;
        try {
            T result;
            boolean isNew;
            boolean existing = this.isExisting();
            boolean bl = isNew = !existing || requiresNew;
            if (existing && requiresNew) {
                oldTx = this.doSuspend();
            }
            if (isNew) {
                this.doBegin();
            }
            try {
                result = this.next.execute(config, command, commandExecutor);
            }
            catch (Error | RuntimeException ex) {
                this.doRollback(isNew, ex);
                throw ex;
            }
            catch (Exception ex) {
                this.doRollback(isNew, ex);
                throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
            }
            if (isNew) {
                this.doCommit();
            }
            t = result;
            this.doResume(oldTx);
        }
        catch (Throwable throwable) {
            this.doResume(oldTx);
            throw throwable;
        }
        return t;
    }

    private void doBegin() {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException | SystemException e) {
            throw new TransactionException("Unable to begin transaction", e);
        }
    }

    private boolean isExisting() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to retrieve transaction status", e);
        }
    }

    private Transaction doSuspend() {
        try {
            return this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to suspend transaction", e);
        }
    }

    private void doResume(Transaction tx) {
        if (tx != null) {
            try {
                this.transactionManager.resume(tx);
            }
            catch (InvalidTransactionException | SystemException e) {
                throw new TransactionException("Unable to resume transaction", e);
            }
        }
    }

    private void doCommit() {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (Error | RuntimeException e) {
            this.doRollback(true, e);
            throw e;
        }
    }

    private void doRollback(boolean isNew, Throwable originalException) {
        Throwable rollbackEx = null;
        try {
            if (isNew) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            LOGGER.debug("Error when rolling back transaction", (Throwable)e);
        }
        catch (Error | RuntimeException e) {
            rollbackEx = e;
            throw e;
        }
        finally {
            if (rollbackEx != null && originalException != null) {
                LOGGER.error("Error when rolling back transaction, original exception was:", originalException);
            }
        }
    }

    private static class TransactionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TransactionException() {
        }

        private TransactionException(String s) {
            super(s);
        }

        private TransactionException(String s, Throwable throwable) {
            super(s, throwable);
        }

        private TransactionException(Throwable throwable) {
            super(throwable);
        }
    }
}

