/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r%r!B\u001e=\u0011\u0003\te!B\"=\u0011\u0003!\u0005\"B&\u0002\t\u0003a\u0005\"B'\u0002\t\u0013q\u0005\"\u00024\u0002\t\u00139\u0007\"\u00029\u0002\t\u0013\t\b\"B?\u0002\t\u0003qh!B\"=\u0001\u0005\u001d\u0001\"CA\u0017\u000f\t\u0005\t\u0015!\u0003\\\u0011!1xA!A!\u0002\u00139\bBCA\u0018\u000f\t\u0005\t\u0015!\u0003\u00022!Q\u0011qI\u0004\u0003\u0002\u0003\u0006I!!\u0013\t\u0015\u0005esA!A!\u0002\u0013\tY\u0006\u0003\u0006\u0002b\u001d\u0011\t\u0011)A\u0005\u0003cA!\"a\u0019\b\u0005\u0003\u0005\u000b\u0011BA3\u0011)\tyg\u0002B\u0001B\u0003%\u0011\u0011\u000f\u0005\u000b\u0003w:!\u0011!Q\u0001\n\u0005u\u0004BCAB\u000f\t\u0015\r\u0011\"\u0001\u0002\u0006\"Q\u0011qW\u0004\u0003\u0002\u0003\u0006I!a\"\t\u0015\u0005evA!A!\u0002\u0013\tY\f\u0003\u0006\u0002B\u001e\u0011\t\u0011)A\u0005\u0003\u0007DaaS\u0004\u0005\u0002\u0005=\u0007\"CAv\u000f\t\u0007I\u0011AAw\u0011!\tYp\u0002Q\u0001\n\u0005=\b\"CA\u007f\u000f\t\u0007I\u0011BA\u0000\u0011!\u0011Ya\u0002Q\u0001\n\t\u0005\u0001\"\u0003B\u0007\u000f\t\u0007I\u0011\u0002B\b\u0011\u001d\u0011\tb\u0002Q\u0001\nmC\u0011Ba\u0005\b\u0005\u0004%IA!\u0006\t\u0011\tuq\u0001)A\u0005\u0005/A\u0011Ba\b\b\u0005\u0004%IA!\t\t\u0011\t5r\u0001)A\u0005\u0005GA\u0001b\\\u0004C\u0002\u0013%!q\u0006\u0005\b\u0005c9\u0001\u0015!\u0003P\u0011%\u0011\u0019d\u0002b\u0001\n\u0013\u0011)\u0004\u0003\u0005\u0003:\u001d\u0001\u000b\u0011\u0002B\u001c\u0011%\u0011Yd\u0002b\u0001\n\u0003\u0012i\u0004\u0003\u0005\u0003F\u001d\u0001\u000b\u0011\u0002B \u0011%\u00119e\u0002b\u0001\n\u0013\u0011I\u0005\u0003\u0005\u0003R\u001d\u0001\u000b\u0011\u0002B&\u0011%\u0011\u0019f\u0002b\u0001\n\u0013\u0011)\u0006\u0003\u0005\u0003d\u001d\u0001\u000b\u0011\u0002B,\u0011%\u0011)g\u0002b\u0001\n\u0013\u00119\u0007\u0003\u0005\u0003p\u001d\u0001\u000b\u0011\u0002B5\u0011%\u0011\th\u0002b\u0001\n\u0003\u0012\u0019\b\u0003\u0005\u0003|\u001d\u0001\u000b\u0011\u0002B;\u0011%\u0011ih\u0002b\u0001\n\u0013\u0011y\b\u0003\u0005\u0003\b\u001e\u0001\u000b\u0011\u0002BA\u0011\u001d\u0011Ii\u0002C\u0001\u0005\u0017CqA!$\b\t\u0003\u0011Y\tC\u0004\u0003\u0010\u001e!\tE!%\t\u000f\t\u0015v\u0001\"\u0011\u0003(\"9!Q[\u0004\u0005\n\t]\u0007b\u0002Bm\u000f\u0011%!1\u001c\u0005\b\u0005;<A\u0011\u0002Bp\u0011\u001d\u0011\to\u0002C\u0005\u0005GDqAa;\b\t\u0013\u0011i\u000fC\u0004\u0004\b\u001d!\te!\u0003\t\u000f\rEq\u0001\"\u0011\u0004\u0014\u0005\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\u0006\u0003{y\nAA]1gi*\tq(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\t\u000bQ\"\u0001\u001f\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u00148CA\u0001F!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!Q\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010F\u0002P/f\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u0005%|'\"\u0001+\u0002\t)\fg/Y\u0005\u0003-F\u0013AAR5mK\")\u0001l\u0001a\u0001\u001f\u00061An\\4ESJDQAW\u0002A\u0002m\u000b!\u0002\\8h\t&\u0014h*Y7f!\ta6M\u0004\u0002^CB\u0011alR\u0007\u0002?*\u0011\u0001\rQ\u0001\u0007yI|w\u000e\u001e \n\u0005\t<\u0015A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!AY$\u0002\u00171|7m\u001b#bi\u0006$\u0015N\u001d\u000b\u0003Q:\u0004\"!\u001b7\u000e\u0003)T!a\u001b \u0002\u000bU$\u0018\u000e\\:\n\u00055T'\u0001\u0003$jY\u0016dunY6\t\u000b=$\u0001\u0019A(\u0002\u000f\u0011\fG/\u0019#je\u0006\u0011\u0002.Y:ES\u001a4WM]3oi2{w\rR5s)\t\u0011X\u000f\u0005\u0002Gg&\u0011Ao\u0012\u0002\b\u0005>|G.Z1o\u0011\u00151X\u00011\u0001x\u0003\u0019\u0019wN\u001c4jOB\u0011\u0001p_\u0007\u0002s*\u0011!PP\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005qL(aC&bM.\f7i\u001c8gS\u001e\f\u0011$\\1zE\u0016$U\r\\3uK6+G/\u00193bi\u0006dun\u001a#jeR\u0019q0!\u0002\u0011\u0007\u0019\u000b\t!C\u0002\u0002\u0004\u001d\u0013A!\u00168ji\")aO\u0002a\u0001oV!\u0011\u0011BA\u000b'\u00199Q)a\u0003\u0002(A)!)!\u0004\u0002\u0012%\u0019\u0011q\u0002\u001f\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0005\u0003'\t)\u0002\u0004\u0001\u0005\u000f\u0005]qA1\u0001\u0002\u001a\t\tA+\u0005\u0003\u0002\u001c\u0005\u0005\u0002c\u0001$\u0002\u001e%\u0019\u0011qD$\u0003\u000f9{G\u000f[5oOB\u0019a)a\t\n\u0007\u0005\u0015rIA\u0002B]f\u00042![A\u0015\u0013\r\tYC\u001b\u0002\b\u0019><w-\u001b8h\u0003%\u0019G.^:uKJLE-\u0001\nnKR\fG-\u0019;b\u0019><G)\u001b:Vk&$\u0007\u0003BA\u001a\u0003\u0007j!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0007G>lWn\u001c8\u000b\u0007}\nYD\u0003\u0003\u0002>\u0005}\u0012AB1qC\u000eDWM\u0003\u0002\u0002B\u0005\u0019qN]4\n\t\u0005\u0015\u0013Q\u0007\u0002\u0005+VLG-A\u0006sK\u000e|'\u000fZ*fe\u0012,\u0007CBA&\u0003+\n\t\"\u0004\u0002\u0002N)!\u0011qJA)\u00035\u0019XM]5bY&T\u0018\r^5p]*!\u0011qGA*\u0015\rQ\u0018\u0011H\u0005\u0005\u0003/\niEA\u0006SK\u000e|'\u000fZ*fe\u0012,\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003g\ti&\u0003\u0003\u0002`\u0005U\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\bi>\u0004\u0018nY%e\u0003\u0011!\u0018.\\3\u0011\t\u0005\u001d\u00141N\u0007\u0003\u0003SR1a[A\u001b\u0013\u0011\ti'!\u001b\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\t\u0019(a\u001e\u000e\u0005\u0005U$\u0002BA8\u0003kIA!!\u001f\u0002v\t9Q*\u001a;sS\u000e\u001c\u0018a\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y\u001fB$\b\u0003\u0002$\u0002\u0000mK1!!!H\u0005\u0019y\u0005\u000f^5p]\u0006a2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,WCAAD!\u0019\tI)a%\u0002\u00186\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0006d_:\u001cWO\u001d:f]RT1!!%T\u0003\u0011)H/\u001b7\n\t\u0005U\u00151\u0012\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CAM\u00037\u000by*a+\u000e\u0005\u0005=\u0015\u0002BAO\u0003\u001f\u00131!T1q!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS'\u0006!A.\u00198h\u0013\u0011\tI+a)\u0003\u000f%sG/Z4feB!\u0011QVAZ\u001b\t\tyKC\u0002\u00022N\u000b1A\\3u\u0013\u0011\t),a,\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8/A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003A\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000f\u0005\u0004\u0002\u001a\u0006u\u00161V\u0005\u0005\u0003\u007f\u000byI\u0001\u0006D_2dWm\u0019;j_:\f\u0011CZ1uC24\u0015-\u001e7u\u0011\u0006tG\r\\3s!\u0011\t)-a3\u000e\u0005\u0005\u001d'\u0002BAe\u0003'\nQAZ1vYRLA!!4\u0002H\naa)Y;mi\"\u000bg\u000e\u001a7feRQ\u0012\u0011[Aj\u0003+\f9.!7\u0002\\\u0006u\u0017q\\Aq\u0003G\f)/a:\u0002jB!!iBA\t\u0011\u0019\ti#\u0006a\u00017\")a/\u0006a\u0001o\"9\u0011qF\u000bA\u0002\u0005E\u0002bBA$+\u0001\u0007\u0011\u0011\n\u0005\b\u00033*\u0002\u0019AA.\u0011\u001d\t\t'\u0006a\u0001\u0003cAq!a\u0019\u0016\u0001\u0004\t)\u0007C\u0004\u0002pU\u0001\r!!\u001d\t\u000f\u0005mT\u00031\u0001\u0002~!9\u00111Q\u000bA\u0002\u0005\u001d\u0005bBA]+\u0001\u0007\u00111\u0018\u0005\b\u0003\u0003,\u0002\u0019AAb\u0003-\t\u0007/\u001b,feNLwN\\:\u0016\u0005\u0005=\b\u0003BAy\u0003ol!!a=\u000b\t\u0005U\u0018\u0011H\u0001\bG2LWM\u001c;t\u0013\u0011\tI0a=\u0003\u0017\u0005\u0003\u0018NV3sg&|gn]\u0001\rCBLg+\u001a:tS>t7\u000fI\u0001\u000be\u00064GoQ8oM&<WC\u0001B\u0001!\u0011\u0011\u0019Aa\u0002\u000e\u0005\t\u0015!bA\u001f\u0002:%!!\u0011\u0002B\u0003\u00051\tVo\u001c:v[\u000e{gNZ5h\u0003-\u0011\u0018M\u001a;D_:4\u0017n\u001a\u0011\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&DX#A.\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"Aa\u0006\u0011\t\u0005\u001d$\u0011D\u0005\u0005\u00057\tIG\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0005G\u0001BA!\n\u0003*5\u0011!q\u0005\u0006\u0005\u0003#\u000b\u0019&\u0003\u0003\u0003,\t\u001d\"AD&bM.\f7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004S#A(\u0002\u0011\u0011\fG/\u0019#je\u0002\n1\u0002Z1uC\u0012K'\u000fT8dWV\u0011!q\u0007\t\u0005\r\u0006}\u0004.\u0001\u0007eCR\fG)\u001b:M_\u000e\\\u0007%A\u0007sKBd\u0017nY1uK\u0012dunZ\u000b\u0003\u0005\u007f\u0001BAa\u0001\u0003B%!!1\tB\u0003\u00055\u0011V\r\u001d7jG\u0006$X\r\u001a'pO\u0006q!/\u001a9mS\u000e\fG/\u001a3M_\u001e\u0004\u0013A\u00038fi\u000eC\u0017M\u001c8fYV\u0011!1\n\t\u0005\u0005\u0007\u0011i%\u0003\u0003\u0003P\t\u0015!aE&bM.\fg*\u001a;x_J\\7\t[1o]\u0016d\u0017a\u00038fi\u000eC\u0017M\u001c8fY\u0002\nq\"\u001a=qSJ\fG/[8o)&lWM]\u000b\u0003\u0005/\u0002BA!\u0017\u0003`5\u0011!1\f\u0006\u0005\u0005;\u00129#A\u0003uS6,'/\u0003\u0003\u0003b\tm#aC*zgR,W\u000eV5nKJ\f\u0001#\u001a=qSJ\fG/[8o)&lWM\u001d\u0011\u0002#\u0015D\b/\u001b:bi&|gnU3sm&\u001cW-\u0006\u0002\u0003jA\u0019!Ia\u001b\n\u0007\t5DH\u0001\u000fUS6LgnZ,iK\u0016dW\t\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0002%\u0015D\b/\u001b:bi&|gnU3sm&\u001cW\rI\u0001\u0007G2LWM\u001c;\u0016\u0005\tU\u0004C\u0002B\u0002\u0005o\n\t\"\u0003\u0003\u0003z\t\u0015!aD&bM.\f'+\u00194u\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005a1\r\\5f]R$%/\u001b<feV\u0011!\u0011\u0011\t\u0007\u0005\u0007\u0011\u0019)!\u0005\n\t\t\u0015%Q\u0001\u0002\u0016\u0017\u000647.\u0019*bMR\u001cE.[3oi\u0012\u0013\u0018N^3s\u00035\u0019G.[3oi\u0012\u0013\u0018N^3sA\u000591\u000f^1siV\u0004H#A@\u0002\u0011MDW\u000f\u001e3po:\f\u0001B]3hSN$XM\u001d\u000b\u0004\u007f\nM\u0005b\u0002BKe\u0001\u0007!qS\u0001\tY&\u001cH/\u001a8feB1!\u0011\u0014BP\u0003#qAAa\u0001\u0003\u001c&!!Q\u0014B\u0003\u0003)\u0011\u0016M\u001a;DY&,g\u000e^\u0005\u0005\u0005C\u0013\u0019K\u0001\u0005MSN$XM\\3s\u0015\u0011\u0011iJ!\u0002\u0002\u001b!\fg\u000e\u001a7f%\u0016\fX/Z:u)!\u0011IKa.\u0003H\n-\u0007CBAE\u0003'\u0013Y\u000b\u0005\u0003\u0003.\nMVB\u0001BX\u0015\u0011\u0011\t,!\u000e\u0002\u0011A\u0014x\u000e^8d_2LAA!.\u00030\nQ\u0011\t]5NKN\u001c\u0018mZ3\t\u000f\te6\u00071\u0001\u0003<\u00061\u0001.Z1eKJ\u0004BA!0\u0003D6\u0011!q\u0018\u0006\u0005\u0005\u0003\f)$\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011)Ma0\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\u0011Im\ra\u0001\u0005W\u000bqA]3rk\u0016\u001cH\u000fC\u0004\u0003NN\u0002\rAa4\u0002\u001b\r\u0014X-\u0019;fIRKW.Z't!\r1%\u0011[\u0005\u0004\u0005'<%\u0001\u0002'p]\u001e\fqBY;jY\u0012\u0014\u0016M\u001a;DY&,g\u000e\u001e\u000b\u0003\u0005k\n1CY;jY\u0012tU\r^<pe.\u001c\u0005.\u00198oK2$\"Aa\u0013\u0002\u001b\r\u0014X-\u0019;f\t\u0006$\u0018\rR5s)\u0005y\u0015\u0001\u00052vS2$W*\u001a;bI\u0006$\u0018\rT8h)\t\u0011)\u000fE\u0002C\u0005OL1A!;=\u0005AY\u0015MZ6b\u001b\u0016$\u0018\rZ1uC2{w-\u0001\nck&dGMT3uo>\u00148n\u00117jK:$HC\u0001Bx!\u001d1%\u0011\u001fB{\u0007\u0003I1Aa=H\u0005\u0019!V\u000f\u001d7feA!!q\u001fB\u007f\u001b\t\u0011IP\u0003\u0003\u0003|\u0006U\u0012a\u00028fi^|'o[\u0005\u0005\u0005\u007f\u0014IP\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0005\u0003\u0002r\u000e\r\u0011\u0002BB\u0003\u0003g\u0014QBT3uo>\u00148n\u00117jK:$\u0018A\u00047fC\u0012,'/\u00118e\u000bB|7\r[\u000b\u0003\u0007\u0017\u0001BAa\u0001\u0004\u000e%!1q\u0002B\u0003\u00059aU-\u00193fe\u0006sG-\u00129pG\"\f\u0011B^8uKJtu\u000eZ3\u0015\r\rU1QDB\u0014!\u00151\u0015qPB\f!\u0011\t\u0019d!\u0007\n\t\rm\u0011Q\u0007\u0002\u0005\u001d>$W\rC\u0004\u0004 i\u0002\ra!\t\u0002\u0005%$\u0007c\u0001$\u0004$%\u00191QE$\u0003\u0007%sG\u000fC\u0004\u0003\u0016j\u0002\rA!>")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybeDeleteMetadataLogDir(KafkaConfig config) {
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(config);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.clientDriver().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$3 -> {
            x$3.destroy();
            return BoxedUnit.UNIT;
        }), this, Level.WARN);
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(header, request, createdTimeMs);
    }

    private KafkaRaftClient<T> buildRaftClient() {
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.clusterId, this.bootstrapServers, this.raftConfig());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        return new KafkaNetworkChannel(this.time, (ListenerName)var2_2, (KafkaClient)var3_3, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.client().voterNode(id, listener)));
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, FaultHandler fatalFaultHandler) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
    }
}

