/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;

public class RealmUtils {
    private static final Predicate<String> DYN_REALMS_PREDICATE = r -> !r.startsWith("/");
    protected final Map<String, Field> fields = new HashMap<String, Field>();

    public static boolean normalizingAddTo(Set<String> realms, String newRealm) {
        boolean dontAdd = false;
        HashSet<String> toRemove = new HashSet<String>();
        for (String realm : realms) {
            if (newRealm.startsWith(realm)) {
                dontAdd = true;
                continue;
            }
            if (!realm.startsWith(newRealm)) continue;
            toRemove.add(realm);
        }
        realms.removeAll(toRemove);
        if (!dontAdd) {
            realms.add(newRealm);
        }
        return !dontAdd;
    }

    public static Set<String> getEffective(Set<String> allowedRealms, String requestedRealm) {
        NormalizedRealms normalized = NormalizedRealms.of(allowedRealms);
        Set<String> requested = Set.of(requestedRealm);
        StartsWithPredicate normalizedFilter = new StartsWithPredicate(normalized.realms());
        StartsWithPredicate requestedFilter = new StartsWithPredicate(requested);
        HashSet<String> effective = new HashSet<String>();
        effective.addAll(requested.stream().filter(normalizedFilter).collect(Collectors.toSet()));
        effective.addAll(normalized.realms().stream().filter(requestedFilter).collect(Collectors.toSet()));
        effective.addAll(normalized.groupOwnerRealms());
        if (allowedRealms != null) {
            effective.addAll(allowedRealms.stream().filter(DYN_REALMS_PREDICATE).collect(Collectors.toSet()));
        }
        return effective;
    }

    protected static void initFieldNames(Class<?> entityClass, Map<String, Field> fields) {
        List classes = ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        classes.forEach(clazz -> {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("pc") || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                fields.put(field.getName(), field);
                if (!"id".equals(field.getName())) continue;
                fields.put("key", field);
            }
        });
    }

    public RealmUtils(EntityFactory entityFactory) {
        RealmUtils.initFieldNames(entityFactory.realmClass(), this.fields);
    }

    public Optional<Field> getField(String name) {
        return Optional.ofNullable(this.fields.get(name));
    }

    public record NormalizedRealms(Set<String> realms, Set<String> groupOwnerRealms) {
        public static NormalizedRealms of(Collection<String> input) {
            HashSet<String> realms = new HashSet<String>();
            HashSet<String> groupOwnerRealms = new HashSet<String>();
            if (input != null) {
                input.forEach(realm -> {
                    if (realm.indexOf(64) == -1) {
                        RealmUtils.normalizingAddTo(realms, realm);
                    } else {
                        groupOwnerRealms.add((String)realm);
                    }
                });
            }
            return new NormalizedRealms(realms, groupOwnerRealms);
        }
    }

    private static class StartsWithPredicate
    implements Predicate<String> {
        private final Collection<String> targets;

        StartsWithPredicate(Collection<String> targets) {
            this.targets = targets;
        }

        @Override
        public boolean test(String realm) {
            return this.targets.stream().anyMatch(realm::startsWith);
        }
    }

    public record GroupOwnerRealm(String realmPath, String groupKey) {
        public static Optional<GroupOwnerRealm> of(String input) {
            String[] split = input.split("@");
            return split == null || split.length < 2 ? Optional.empty() : Optional.of(new GroupOwnerRealm(split[0], split[1]));
        }

        public String output() {
            return this.realmPath + "@" + this.groupKey;
        }
    }
}

