/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public class DropDownVariationBehavior
extends BootstrapBaseBehavior {
    private static final long serialVersionUID = 1L;
    private final IModel<Variation> variation;

    public DropDownVariationBehavior(IModel<Variation> variation) {
        this.variation = (IModel)Args.notNull(variation, (String)"variation");
    }

    public DropDownVariationBehavior(Variation variation) {
        this((IModel<Variation>)Model.of((Serializable)((Object)((Variation)Args.notNull((Object)variation, (String)"variation")))));
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.removeClass(tag, Variation.DROPSTART.cssClassName(), Variation.DROPEND.cssClassName(), Variation.DROPUP.cssClassName());
        Variation value = (Variation)this.variation.getObject();
        switch (value) {
            case DROPSTART: 
            case DROPEND: 
            case DROPUP: {
                Attributes.addClass(tag, value.cssClassName());
            }
        }
    }

    public DropDownVariationBehavior setVariation(Variation variation) {
        this.variation.setObject((Object)variation);
        return this;
    }

    public void detach(Component component) {
        super.detach(component);
        this.variation.detach();
    }

    public static enum Variation implements ICssClassNameProvider
    {
        DROPEND("dropend"),
        DROPSTART("dropstart"),
        DROPUP("dropup"),
        DROPDOWN("");

        private String className;

        private Variation(String className) {
            this.className = className;
        }

        @Override
        public String cssClassName() {
            return this.className;
        }
    }
}

