/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.kafka.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import net.tirasa.connid.bundles.kafka.serialization.AttributeDeserializer;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;

public class ConnectorObjectDeserializer
extends JsonDeserializer<ConnectorObject> {
    private static final AttributeDeserializer ATTR_DESERIALIZER = new AttributeDeserializer();

    public ConnectorObject deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        ObjectNode tree = (ObjectNode)jp.readValueAsTree();
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        if (tree.has("objectClass")) {
            builder.setObjectClass(new ObjectClass(tree.get("objectClass").get("type").asText()));
        }
        if (tree.has("attributeMap")) {
            JsonParser parser = tree.get("attributeMap").traverse();
            parser.setCodec(jp.getCodec());
            Map attributeMap = (Map)parser.readValueAs((TypeReference)new TypeReference<Map<String, ObjectNode>>(){});
            for (ObjectNode attribute : attributeMap.values()) {
                JsonParser p = attribute.traverse();
                p.setCodec(jp.getCodec());
                builder.addAttribute(new Attribute[]{ATTR_DESERIALIZER.deserialize(p, ctx)});
            }
        }
        return builder.build();
    }
}

