/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.delegate;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.VariableAggregationDefinition;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.variable.VariableAggregator;
import org.flowable.engine.delegate.variable.VariableAggregatorContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;

public class JsonVariableAggregator
implements VariableAggregator {
    protected final ProcessEngineConfigurationImpl processEngineConfiguration;

    public JsonVariableAggregator(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public Object aggregateSingleVariable(DelegateExecution execution, VariableAggregatorContext context) {
        ObjectNode objectNode = this.processEngineConfiguration.getObjectMapper().createObjectNode();
        VariableServiceConfiguration variableServiceConfiguration = this.processEngineConfiguration.getVariableServiceConfiguration();
        VariableService variableService = variableServiceConfiguration.getVariableService();
        block36: for (VariableAggregationDefinition.Variable definition : context.getDefinition().getDefinitions()) {
            String varInstanceTypeName;
            String targetVarName = null;
            if (StringUtils.isNotEmpty((CharSequence)definition.getTargetExpression())) {
                Object value = this.processEngineConfiguration.getExpressionManager().createExpression(definition.getTargetExpression()).getValue((VariableContainer)execution);
                if (value != null) {
                    targetVarName = value.toString();
                }
            } else if (StringUtils.isNotEmpty((CharSequence)definition.getTarget())) {
                targetVarName = definition.getTarget();
            } else if (StringUtils.isNotEmpty((CharSequence)definition.getSource())) {
                targetVarName = definition.getSource();
            }
            if (targetVarName == null) continue;
            VariableInstance varInstance = null;
            if (StringUtils.isNotEmpty((CharSequence)definition.getSource())) {
                varInstance = execution.getVariableInstance(definition.getSource());
            } else if (StringUtils.isNotEmpty((CharSequence)definition.getSourceExpression())) {
                Object sourceValue = this.processEngineConfiguration.getExpressionManager().createExpression(definition.getSourceExpression()).getValue((VariableContainer)execution);
                varInstance = variableService.createVariableInstance(targetVarName);
                variableServiceConfiguration.getVariableInstanceValueModifier().setVariableValue(varInstance, sourceValue, execution.getTenantId());
            }
            if (varInstance == null) continue;
            switch (varInstanceTypeName = varInstance.getTypeName()) {
                case "string": 
                case "longString": {
                    objectNode.put(targetVarName, (String)varInstance.getValue());
                    continue block36;
                }
                case "json": {
                    objectNode.set(targetVarName, (JsonNode)varInstance.getValue());
                    continue block36;
                }
                case "boolean": {
                    objectNode.put(targetVarName, (Boolean)varInstance.getValue());
                    continue block36;
                }
                case "short": {
                    objectNode.put(targetVarName, (Short)varInstance.getValue());
                    continue block36;
                }
                case "integer": {
                    objectNode.put(targetVarName, (Integer)varInstance.getValue());
                    continue block36;
                }
                case "long": {
                    objectNode.put(targetVarName, (Long)varInstance.getValue());
                    continue block36;
                }
                case "double": {
                    objectNode.put(targetVarName, (Double)varInstance.getValue());
                    continue block36;
                }
                case "bigdecimal": {
                    objectNode.put(targetVarName, (BigDecimal)varInstance.getValue());
                    continue block36;
                }
                case "biginteger": {
                    objectNode.put(targetVarName, (BigInteger)varInstance.getValue());
                    continue block36;
                }
                case "date": {
                    objectNode.put(targetVarName, ((Date)varInstance.getValue()).toInstant().toString());
                    continue block36;
                }
                case "null": {
                    objectNode.putNull(targetVarName);
                    continue block36;
                }
                case "instant": 
                case "localdate": 
                case "localdatetime": 
                case "jodadate": 
                case "jodadatetime": 
                case "uuid": {
                    objectNode.put(targetVarName, varInstance.getValue().toString());
                    continue block36;
                }
                case "bytes": {
                    objectNode.put(targetVarName, (byte[])varInstance.getValue());
                    continue block36;
                }
            }
            if ("overview".equals(context.getState())) {
                Object value = varInstance.getValue();
                if (value instanceof JsonNode) {
                    objectNode.set(targetVarName, (JsonNode)value);
                    continue;
                }
                throw new FlowableException("Cannot aggregate overview variable: " + String.valueOf(varInstance));
            }
            throw new FlowableException("Cannot aggregate variable: " + String.valueOf(varInstance));
        }
        return objectNode;
    }

    @Override
    public Object aggregateMultiVariables(DelegateExecution execution, List<? extends VariableInstance> instances, VariableAggregatorContext context) {
        ObjectMapper objectMapper = this.processEngineConfiguration.getObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        for (VariableInstance variableInstance : instances) {
            arrayNode.add((JsonNode)variableInstance.getValue());
        }
        return arrayNode;
    }
}

