/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter;

import java.util.Comparator;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStart;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.core.provisioning.java.job.JobStatusUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class SyncopeCoreStart
extends KeymasterStart
implements Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeCoreStart.class);
    private final DomainHolder<?> domainHolder;

    public SyncopeCoreStart(DomainHolder<?> domainHolder) {
        super(NetworkService.Type.CORE);
        this.domainHolder = domainHolder;
    }

    public int getOrder() {
        return 0;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        event.getApplicationContext().getBeansOfType(SyncopeCoreLoader.class).values().stream().sorted(Comparator.comparing(Ordered::getOrder)).forEachOrdered(loader -> {
            String loaderName = AopUtils.getTargetClass((Object)loader).getName();
            LOG.debug("[{}#{}] Starting init", (Object)loaderName, (Object)loader.getOrder());
            loader.load();
            this.domainHolder.getDomains().keySet().forEach(domain -> {
                LOG.debug("[{}] Starting init on domain '{}'", (Object)loaderName, domain);
                loader.load(domain);
                LOG.debug("[{}] Init completed on domain '{}'", (Object)loaderName, domain);
            });
            LOG.debug("[{}] Init completed", (Object)loaderName);
        });
        super.onApplicationEvent(event);
        ((JobStatusUpdater)event.getApplicationContext().getBean(JobStatusUpdater.class)).initComplete();
    }
}

