/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.javax;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.IApplicationListener;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.javax.JavaxWebSocketProcessor;
import org.apache.wicket.protocol.ws.javax.JavaxWebSocketSession;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketEndpoint
extends Endpoint {
    private static final Logger LOG = LoggerFactory.getLogger(WicketEndpoint.class);
    private static final Set<String> RUNNING_APPLICATIONS = ConcurrentHashMap.newKeySet();
    private static final String WICKET_APP_PARAM_NAME = "wicket-app-name";
    private String applicationName;
    private JavaxWebSocketProcessor javaxWebSocketProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        this.applicationName = this.getApplicationName(session);
        WebApplication app = (WebApplication)WebApplication.get((String)this.applicationName);
        if (RUNNING_APPLICATIONS.add(this.applicationName)) {
            app.getApplicationListeners().add((Object)new ApplicationListener());
        }
        try {
            ThreadContext.setApplication((Application)app);
            this.javaxWebSocketProcessor = new JavaxWebSocketProcessor(session, app, endpointConfig);
            this.javaxWebSocketProcessor.onOpen(new JavaxWebSocketSession(session), app);
        }
        finally {
            ThreadContext.detach();
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        super.onClose(session, closeReason);
        int closeCode = closeReason.getCloseCode().getCode();
        String reasonPhrase = closeReason.getReasonPhrase();
        LOG.debug("Web Socket connection with id '{}' has been closed with code '{}' and reason: {}", new Object[]{session.getId(), closeCode, reasonPhrase});
        if (this.javaxWebSocketProcessor != null && this.isApplicationAlive(this.applicationName)) {
            this.javaxWebSocketProcessor.onClose(closeCode, reasonPhrase);
        }
    }

    public void onError(Session session, Throwable t) {
        if (this.isIgnorableError(t)) {
            LOG.debug("An error occurred in web socket connection with id : {}", (Object)session.getId(), (Object)t);
        } else {
            LOG.error("An error occurred in web socket connection with id : {}", (Object)session.getId(), (Object)t);
        }
        super.onError(session, t);
        if (this.javaxWebSocketProcessor != null && this.isApplicationAlive(this.applicationName)) {
            this.javaxWebSocketProcessor.onError(t);
        }
    }

    private boolean isIgnorableError(Throwable t) {
        return t instanceof EOFException || t instanceof IOException && "Broken pipe".equals(t.getMessage());
    }

    private boolean isApplicationAlive(String appName) {
        return RUNNING_APPLICATIONS.contains(appName);
    }

    private String getApplicationName(Session session) {
        String appName = null;
        Map parameters = session.getRequestParameterMap();
        if (parameters != null) {
            appName = (String)((List)parameters.get(WICKET_APP_PARAM_NAME)).get(0);
        } else {
            String queryString = session.getQueryString();
            if (!Strings.isEmpty((String)queryString)) {
                String[] params;
                for (String paramPair : params = Strings.split((String)queryString, (char)'&')) {
                    String[] nameValues = Strings.split((String)paramPair, (char)'=');
                    if (!WICKET_APP_PARAM_NAME.equals(nameValues[0])) continue;
                    appName = nameValues[1];
                }
            }
        }
        Checks.notNull((Object)appName, (String)"The application name cannot be read from the upgrade request's parameters", (Object[])new Object[0]);
        return appName;
    }

    private static class ApplicationListener
    implements IApplicationListener {
        private ApplicationListener() {
        }

        public void onBeforeDestroyed(Application application) {
            String appName = application.getName();
            RUNNING_APPLICATIONS.remove(appName);
            application.getApplicationListeners().remove((Object)this);
        }
    }
}

