/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.validation.JAXRSBeanValidationInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.syncope.core.logic.AnyObjectLogic;
import org.apache.syncope.core.logic.GroupLogic;
import org.apache.syncope.core.logic.SCIMDataBinder;
import org.apache.syncope.core.logic.SCIMLogic;
import org.apache.syncope.core.logic.UserLogic;
import org.apache.syncope.core.logic.scim.SCIMConfManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.ext.scimv2.api.service.SCIMAnyObjectService;
import org.apache.syncope.ext.scimv2.api.service.SCIMGroupService;
import org.apache.syncope.ext.scimv2.api.service.SCIMService;
import org.apache.syncope.ext.scimv2.api.service.SCIMUserService;
import org.apache.syncope.ext.scimv2.cxf.AddETagFilter;
import org.apache.syncope.ext.scimv2.cxf.SCIMExceptionMapper;
import org.apache.syncope.ext.scimv2.cxf.service.SCIMAnyObjectServiceImpl;
import org.apache.syncope.ext.scimv2.cxf.service.SCIMGroupServiceImpl;
import org.apache.syncope.ext.scimv2.cxf.service.SCIMServiceImpl;
import org.apache.syncope.ext.scimv2.cxf.service.SCIMUserServiceImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class SCIMv2RESTCXFContext {
    @ConditionalOnMissingBean
    @Bean
    public JacksonJsonProvider scimJacksonJsonProvider() {
        return new JacksonJsonProvider(((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).build());
    }

    @ConditionalOnMissingBean
    @Bean
    public SCIMExceptionMapper scimExceptionMapper() {
        return new SCIMExceptionMapper();
    }

    @ConditionalOnMissingBean(name={"scimAddETagFilter"})
    @Bean
    public AddETagFilter scimAddETagFilter() {
        return new AddETagFilter();
    }

    @ConditionalOnMissingBean(name={"scimv2Container"})
    @Bean
    public Server scimv2Container(SCIMService scimService, SCIMGroupService scimv2GroupService, SCIMUserService scimv2UserService, SCIMAnyObjectService scimv2AnyObjectService, GZIPInInterceptor gzipInInterceptor, GZIPOutInterceptor gzipOutInterceptor, JAXRSBeanValidationInInterceptor validationInInterceptor, JacksonJsonProvider scimJacksonJsonProvider, SCIMExceptionMapper scimExceptionMapper, AddETagFilter scimAddETagFilter, Bus bus, ApplicationContext ctx) {
        JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean scimv2Container = new JAXRSServerFactoryBeanDefinitionParser.SpringJAXRSServerFactoryBean();
        scimv2Container.setBus(bus);
        scimv2Container.setAddress("/scim");
        scimv2Container.setStaticSubresourceResolution(true);
        scimv2Container.setProperties(Map.of("convert.wadl.resources.to.dom", "false"));
        scimv2Container.setServiceBeans(List.of(scimService, scimv2GroupService, scimv2UserService, scimv2AnyObjectService));
        scimv2Container.setInInterceptors(List.of(gzipInInterceptor, validationInInterceptor));
        scimv2Container.setOutInterceptors(List.of(gzipOutInterceptor));
        scimv2Container.setProviders(List.of(scimJacksonJsonProvider, scimExceptionMapper, scimAddETagFilter));
        scimv2Container.setApplicationContext(ctx);
        return scimv2Container.create();
    }

    @ConditionalOnMissingBean
    @Bean
    public SCIMService scimService(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, SCIMDataBinder binder, SCIMConfManager confManager, SCIMLogic scimLogic) {
        return new SCIMServiceImpl(userDAO, groupDAO, anyObjectDAO, userLogic, groupLogic, anyObjectLogic, binder, confManager, scimLogic);
    }

    @ConditionalOnMissingBean
    @Bean
    public SCIMGroupService scimv2GroupService(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, SCIMDataBinder binder, SCIMConfManager confManager, JexlTools jexlTools) {
        return new SCIMGroupServiceImpl(userDAO, groupDAO, anyObjectDAO, userLogic, groupLogic, anyObjectLogic, binder, confManager, jexlTools);
    }

    @ConditionalOnMissingBean
    @Bean
    public SCIMUserService scimv2UserService(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        return new SCIMUserServiceImpl(userDAO, groupDAO, anyObjectDAO, userLogic, groupLogic, anyObjectLogic, binder, confManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public SCIMAnyObjectService scimv2AnyObjectService(UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, UserLogic userLogic, GroupLogic groupLogic, AnyObjectLogic anyObjectLogic, SCIMDataBinder binder, SCIMConfManager confManager) {
        return new SCIMAnyObjectServiceImpl(userDAO, groupDAO, anyObjectDAO, userLogic, groupLogic, anyObjectLogic, binder, confManager);
    }
}

