/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import lombok.Generated;
import org.pac4j.core.profile.BasicUserProfile;
import org.pac4j.core.profile.Gender;

public class CommonProfile
extends BasicUserProfile {
    private static final long serialVersionUID = -1856159870249261877L;

    public CommonProfile() {
        this(true);
    }

    public CommonProfile(boolean canMergeAttributes) {
        super(canMergeAttributes);
    }

    @JsonIgnore
    public String getEmail() {
        return this.getAttributeAsString("email");
    }

    @JsonIgnore
    public String getFirstName() {
        return this.getAttributeAsString("first_name");
    }

    @JsonIgnore
    public String getFamilyName() {
        return this.getAttributeAsString("family_name");
    }

    @JsonIgnore
    public String getDisplayName() {
        return this.getAttributeAsString("display_name");
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.getAttributeAsString("username");
    }

    @JsonIgnore
    public Gender getGender() {
        return this.getAttributeAsType("gender", Gender.class, Gender.UNSPECIFIED);
    }

    @JsonIgnore
    public Locale getLocale() {
        return this.getAttributeAsType("locale", Locale.class, null);
    }

    @JsonIgnore
    public URI getPictureUrl() {
        return this.getAttributeAsType("picture_url", URI.class, null);
    }

    @JsonIgnore
    public URI getProfileUrl() {
        return this.getAttributeAsType("profile_url", URI.class, null);
    }

    @JsonIgnore
    public String getLocation() {
        return this.getAttributeAsString("location");
    }

    @Override
    @JsonIgnore
    public boolean isExpired() {
        return false;
    }

    protected String getAttributeAsString(String name) {
        Object value = this.getAttribute(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected <T> T getAttributeAsType(String name, Class<T> clazz, T defaultValue) {
        Object value = this.getAttribute(name);
        if (value != null && clazz.isAssignableFrom(value.getClass())) {
            return clazz.cast(value);
        }
        return defaultValue;
    }

    protected Date getAttributeAsDate(String name) {
        Object value = this.getAttribute(name);
        if (value instanceof Long) {
            Long l = (Long)value;
            return new Date(l);
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return new Date(d.longValue());
        }
        return (Date)this.getAttribute(name);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CommonProfile(super=" + super.toString() + ")";
    }
}

