/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.column.panel;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.wicketstuff.egrid.component.EditableDataTable;
import org.wicketstuff.egrid.component.EditableTableSubmitLink;

public abstract class ActionsPanel<T>
extends Panel {
    private static final long serialVersionUID = 1L;
    private final Item<T> rowItem;

    public ActionsPanel(String id, Item<T> rowItem) {
        super(id, rowItem.getModel());
        this.rowItem = rowItem;
        this.add(new Component[]{this.newEditLink("edit"), this.newCancelLink("cancel"), this.newSaveLink("save"), this.newDeleteLink("delete")});
    }

    protected AjaxLink<Void> newEditLink(String id) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ActionsPanel.this.allowEdit(ActionsPanel.this.rowItem) && !ActionsPanel.this.isRowInEditMode(ActionsPanel.this.rowItem));
            }

            public void onClick(AjaxRequestTarget target) {
                ActionsPanel.this.onEdit(target);
            }
        };
    }

    protected AjaxLink<Void> newCancelLink(String id) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ActionsPanel.this.allowEdit(ActionsPanel.this.rowItem) && ActionsPanel.this.isRowInEditMode(ActionsPanel.this.rowItem));
            }

            public void onClick(AjaxRequestTarget target) {
                ActionsPanel.this.onCancel(target);
            }
        };
    }

    protected EditableTableSubmitLink newSaveLink(String id) {
        return new EditableTableSubmitLink(id, (WebMarkupContainer)this.rowItem){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ActionsPanel.this.allowEdit(ActionsPanel.this.rowItem) && ActionsPanel.this.isRowInEditMode(ActionsPanel.this.rowItem));
            }

            @Override
            protected void onSuccess(AjaxRequestTarget target) {
                ActionsPanel.this.onSave(target);
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                ActionsPanel.this.onError(target);
            }
        };
    }

    protected AjaxLink<Void> newDeleteLink(String id) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                this.setVisible(ActionsPanel.this.allowDelete(ActionsPanel.this.rowItem) && !ActionsPanel.this.isRowInEditMode(ActionsPanel.this.rowItem));
            }

            public void onClick(AjaxRequestTarget target) {
                ActionsPanel.this.onDelete(target);
            }
        };
    }

    protected boolean isRowInEditMode(Item<T> rowItem) {
        Boolean editing = (Boolean)rowItem.getMetaData(EditableDataTable.EDITING);
        return editing != null && editing != false;
    }

    protected void onEdit(AjaxRequestTarget target) {
    }

    protected void onCancel(AjaxRequestTarget target) {
    }

    protected void onSave(AjaxRequestTarget target) {
    }

    protected abstract void onError(AjaxRequestTarget var1);

    protected void onDelete(AjaxRequestTarget target) {
    }

    protected boolean allowEdit(Item<T> rowItem) {
        return true;
    }

    protected boolean allowDelete(Item<T> rowItem) {
        return true;
    }
}

