/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Generated;

public final class AuthenticatorDataFlags {
    public final byte value;
    public final boolean UP;
    public final boolean UV;
    @Deprecated
    public final boolean BE;
    @Deprecated
    public final boolean BS;
    public final boolean AT;
    public final boolean ED;

    @JsonCreator
    public AuthenticatorDataFlags(@JsonProperty(value="value") byte value) {
        this.value = value;
        this.UP = (value & 1) != 0;
        this.UV = (value & 4) != 0;
        this.BE = (value & 8) != 0;
        this.BS = (value & 0x10) != 0;
        this.AT = (value & 0x40) != 0;
        boolean bl = this.ED = (value & 0xFFFFFF80) != 0;
        if (this.BS && !this.BE) {
            throw new IllegalArgumentException(String.format("Flag combination is invalid: BE=0, BS=1 in flags: 0x%02x", value));
        }
    }

    @Generated
    public String toString() {
        return "AuthenticatorDataFlags(value=" + this.value + ", UP=" + this.UP + ", UV=" + this.UV + ", BE=" + this.BE + ", BS=" + this.BS + ", AT=" + this.AT + ", ED=" + this.ED + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticatorDataFlags)) {
            return false;
        }
        AuthenticatorDataFlags other = (AuthenticatorDataFlags)o;
        if (this.value != other.value) {
            return false;
        }
        if (this.UP != other.UP) {
            return false;
        }
        if (this.UV != other.UV) {
            return false;
        }
        if (this.BE != other.BE) {
            return false;
        }
        if (this.BS != other.BS) {
            return false;
        }
        if (this.AT != other.AT) {
            return false;
        }
        return this.ED == other.ED;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.value;
        result = result * 59 + (this.UP ? 79 : 97);
        result = result * 59 + (this.UV ? 79 : 97);
        result = result * 59 + (this.BE ? 79 : 97);
        result = result * 59 + (this.BS ? 79 : 97);
        result = result * 59 + (this.AT ? 79 : 97);
        result = result * 59 + (this.ED ? 79 : 97);
        return result;
    }

    private static final class Bitmasks {
        static final byte UP = 1;
        static final byte UV = 4;
        static final byte BE = 8;
        static final byte BS = 16;
        static final byte AT = 64;
        static final byte ED = -128;

        private Bitmasks() {
        }
    }
}

