/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AttributableTO;
import org.apache.syncope.core.persistence.api.attrvalue.DropdownValueProvider;
import org.apache.syncope.core.persistence.api.attrvalue.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.jexl.JexlTools;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AttributableDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AttributableDataBinder.class);
    protected final PlainSchemaDAO plainSchemaDAO;
    protected final PlainAttrValidationManager validator;
    protected final DerAttrHandler derAttrHandler;
    protected final MappingManager mappingManager;
    protected final IntAttrNameParser intAttrNameParser;
    protected final JexlTools jexlTools;
    private final Map<String, DropdownValueProvider> dropdownValueProviders = new ConcurrentHashMap<String, DropdownValueProvider>();

    protected AttributableDataBinder(PlainSchemaDAO plainSchemaDAO, PlainAttrValidationManager validator, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, JexlTools jexlTools) {
        this.plainSchemaDAO = plainSchemaDAO;
        this.validator = validator;
        this.derAttrHandler = derAttrHandler;
        this.mappingManager = mappingManager;
        this.intAttrNameParser = intAttrNameParser;
        this.jexlTools = jexlTools;
    }

    protected Optional<PlainSchema> getPlainSchema(String schemaName) {
        PlainSchema schema = null;
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            schema = this.plainSchemaDAO.findById(schemaName).orElse(null);
            if (schema == null) {
                LOG.debug("Ignoring invalid schema {}", (Object)schemaName);
            } else if (schema.isReadonly()) {
                schema = null;
                LOG.debug("Ignoring readonly schema {}", (Object)schemaName);
            }
        }
        return Optional.ofNullable(schema);
    }

    protected void checkMandatory(PlainSchema schema, PlainAttr attr, Attributable attributable, SyncopeClientException reqValMissing) {
        if (attr == null && !schema.isReadonly() && this.jexlTools.evaluateMandatoryCondition(schema.getMandatoryCondition(), attributable, this.derAttrHandler)) {
            LOG.error("Mandatory schema {} not provided with values", (Object)schema.getKey());
            reqValMissing.getElements().add(schema.getKey());
        }
    }

    protected void fillAttr(AttributableTO attributableTO, List<String> values, PlainSchema schema, PlainAttr attr, SyncopeClientException invalidValues) {
        List<String> valuesProvided = schema.isMultivalue() ? values : (values.isEmpty() || values.getFirst() == null ? List.of() : List.of(values.getFirst()));
        valuesProvided.forEach(value -> {
            if (StringUtils.isBlank((CharSequence)value)) {
                LOG.debug("Null value for {}, ignoring", (Object)schema.getKey());
            } else {
                try {
                    switch (schema.getType()) {
                        case Enum: {
                            if (schema.getEnumValues().containsKey(value)) break;
                            throw new InvalidPlainAttrValueException("'" + value + "' is not one of: " + String.valueOf(schema.getEnumValues().keySet()));
                        }
                        case Dropdown: {
                            List dropdownValues = List.of();
                            try {
                                DropdownValueProvider provider = (DropdownValueProvider)ImplementationManager.build((Implementation)schema.getDropdownValueProvider(), () -> this.dropdownValueProviders.get(schema.getDropdownValueProvider().getKey()), instance -> this.dropdownValueProviders.put(schema.getDropdownValueProvider().getKey(), (DropdownValueProvider)instance));
                                dropdownValues = provider.getChoices(attributableTO);
                            }
                            catch (Exception e) {
                                LOG.error("While getting dropdown values for {}", (Object)schema.getKey(), (Object)e);
                            }
                            if (dropdownValues.contains(value)) break;
                            throw new InvalidPlainAttrValueException("'" + value + "' is not one of: " + String.valueOf(dropdownValues));
                        }
                    }
                    attr.add(this.validator, value);
                }
                catch (InvalidPlainAttrValueException e) {
                    LOG.warn("Invalid value for attribute {}: {}", new Object[]{schema.getKey(), StringUtils.abbreviate((String)value, (int)20), e});
                    invalidValues.getElements().add(schema.getKey() + ": " + value + " - " + e.getMessage());
                }
            }
        });
    }
}

