/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.core;

import com.github.openjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Generics;
import org.wicketstuff.jquery.core.utils.BuilderUtils;
import org.wicketstuff.jquery.core.utils.DateUtils;

public class Options
implements IClusterable {
    private static final long serialVersionUID = 1L;
    public static final String QUOTE = "\"";
    private final Map<String, Object> map = new HashMap<String, Object>();

    public static String asString(Object value) {
        return Options.asString(String.valueOf(value));
    }

    public static String asString(String value) {
        return JSONObject.quote((String)value);
    }

    public static String asString(List<?> values) {
        ArrayList list = Generics.newArrayList();
        for (Object object : values) {
            list.add(Options.asString(object));
        }
        return ((Object)list).toString();
    }

    public static String asDate(long date) {
        return Options.asDate(new Date(date));
    }

    public static String asDate(Date date) {
        return Options.asString(DateUtils.toString(date));
    }

    public static String fromArray(Object ... objects) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(objects[i]);
        }
        return builder.toString();
    }

    public Options() {
    }

    public Options(Options options) {
        this();
        for (Map.Entry<String, Object> option : options.entries()) {
            this.set(option.getKey(), option.getValue());
        }
    }

    public Options(String key, Object value) {
        this();
        this.set(key, value);
    }

    public Options(String key, Object ... values) {
        this();
        this.set(key, values);
    }

    public Options(String key, List<?> values) {
        this();
        this.set(key, values);
    }

    public <T> T get(String key) {
        Object value = this.map.get(key);
        if (value != null) {
            return (T)value;
        }
        return null;
    }

    public final Options set(String key, Object value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
        return this;
    }

    public final Options set(String key, Object ... values) {
        return this.set(key, Arrays.asList(values));
    }

    public final Options set(String key, List<?> values) {
        return this.set(key, (Object)values.toString());
    }

    public Set<Map.Entry<String, Object>> entries() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{ ");
        int i = 0;
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (i++ > 0) {
                builder.append(", ");
            }
            BuilderUtils.append(builder, entry.getKey(), entry.getValue());
        }
        return builder.append(" }").toString();
    }
}

