/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp.internal;

import io.micrometer.registry.otlp.internal.IndexProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class IndexProviderFactory {
    private static final Map<Integer, IndexProvider> indexProviderCache = new ConcurrentHashMap<Integer, IndexProvider>();
    private static final IndexProvider ZERO_SCALE_INDEX_PROVIDER = new ZeroScaleIndexProvider();

    private IndexProviderFactory() {
    }

    static IndexProvider getIndexProviderForScale(int scale) {
        if (scale > 0) {
            return indexProviderCache.computeIfAbsent(scale, PositiveScaleIndexProvider::new);
        }
        if (scale < 0) {
            return indexProviderCache.computeIfAbsent(scale, x$0 -> new NegativeScaleIndexProvider((int)x$0));
        }
        return ZERO_SCALE_INDEX_PROVIDER;
    }

    private static class NegativeScaleIndexProvider
    implements IndexProvider {
        private final int scale;

        private NegativeScaleIndexProvider(int scale) {
            this.scale = scale;
        }

        @Override
        public int getIndexForValue(double value) {
            return ZERO_SCALE_INDEX_PROVIDER.getIndexForValue(value) >> -this.scale;
        }
    }

    private static class ZeroScaleIndexProvider
    implements IndexProvider {
        private static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
        private static final long EXPONENT_MASK = 0x7FF0000000000000L;
        private static final int SIGNIFICAND_WIDTH = 52;
        private static final int EXPONENT_BIAS = 1023;

        ZeroScaleIndexProvider() {
        }

        @Override
        public int getIndexForValue(double value) {
            long rawBits = Double.doubleToLongBits(value);
            long rawExponent = (rawBits & 0x7FF0000000000000L) >> 52;
            long rawFragment = rawBits & 0xFFFFFFFFFFFFFL;
            if (rawExponent == 0L) {
                rawExponent -= (long)(Long.numberOfLeadingZeros(rawFragment - 1L) - 12);
            }
            int ieeeExponent = (int)(rawExponent - 1023L);
            if (rawFragment == 0L) {
                return ieeeExponent - 1;
            }
            return ieeeExponent;
        }
    }

    private static class PositiveScaleIndexProvider
    implements IndexProvider {
        private final double scaleFactor;

        PositiveScaleIndexProvider(int scale) {
            this.scaleFactor = Math.scalb(Math.log(Math.E) / Math.log(2.0), scale);
        }

        @Override
        public int getIndexForValue(double value) {
            return (int)Math.ceil(Math.log(value) * this.scaleFactor) - 1;
        }
    }
}

