/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yubico.fido.metadata.AAGUID;
import com.yubico.fido.metadata.AAID;
import com.yubico.fido.metadata.AlternativeDescriptions;
import com.yubico.fido.metadata.AttachmentHint;
import com.yubico.fido.metadata.AuthenticationAlgorithm;
import com.yubico.fido.metadata.AuthenticatorAttestationType;
import com.yubico.fido.metadata.AuthenticatorGetInfo;
import com.yubico.fido.metadata.CertFromBase64Converter;
import com.yubico.fido.metadata.CertToBase64Converter;
import com.yubico.fido.metadata.DisplayPNGCharacteristicsDescriptor;
import com.yubico.fido.metadata.ExtensionDescriptor;
import com.yubico.fido.metadata.ProtocolFamily;
import com.yubico.fido.metadata.PublicKeyRepresentationFormat;
import com.yubico.fido.metadata.TransactionConfirmationDisplayType;
import com.yubico.fido.metadata.VerificationMethodDescriptor;
import com.yubico.fido.metadata.Version;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.extension.uvm.KeyProtectionType;
import com.yubico.webauthn.extension.uvm.MatcherProtectionType;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=MetadataStatementBuilder.class)
public final class MetadataStatement {
    private final String legalHeader;
    private final AAID aaid;
    private final AAGUID aaguid;
    private final Set<String> attestationCertificateKeyIdentifiers;
    private final String description;
    private final AlternativeDescriptions alternativeDescriptions;
    private final long authenticatorVersion;
    @NonNull
    private final ProtocolFamily protocolFamily;
    private final int schema;
    @NonNull
    private final Set<Version> upv;
    @NonNull
    private final Set<AuthenticationAlgorithm> authenticationAlgorithms;
    @NonNull
    private final Set<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings;
    @NonNull
    private final Set<AuthenticatorAttestationType> attestationTypes;
    @NonNull
    private final Set<Set<VerificationMethodDescriptor>> userVerificationDetails;
    @NonNull
    private final Set<KeyProtectionType> keyProtection;
    private final Boolean isKeyRestricted;
    private final Boolean isFreshUserVerificationRequired;
    @NonNull
    private final Set<MatcherProtectionType> matcherProtection;
    private final Integer cryptoStrength;
    private final Set<AttachmentHint> attachmentHint;
    @NonNull
    private final Set<TransactionConfirmationDisplayType> tcDisplay;
    private final String tcDisplayContentType;
    private final List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics;
    @JsonDeserialize(contentConverter=CertFromBase64Converter.class)
    @JsonSerialize(contentConverter=CertToBase64Converter.class)
    @NonNull
    private final Set<X509Certificate> attestationRootCertificates;
    private final String icon;
    private final Set<ExtensionDescriptor> supportedExtensions;
    private final AuthenticatorGetInfo authenticatorGetInfo;

    public MetadataStatement(String legalHeader, AAID aaid, AAGUID aaguid, Set<String> attestationCertificateKeyIdentifiers, String description, AlternativeDescriptions alternativeDescriptions, long authenticatorVersion, @NonNull ProtocolFamily protocolFamily, int schema, @NonNull Set<Version> upv, @NonNull Set<AuthenticationAlgorithm> authenticationAlgorithms, @NonNull Set<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings, @NonNull Set<AuthenticatorAttestationType> attestationTypes, @NonNull Set<Set<VerificationMethodDescriptor>> userVerificationDetails, @NonNull Set<KeyProtectionType> keyProtection, Boolean isKeyRestricted, Boolean isFreshUserVerificationRequired, @NonNull Set<MatcherProtectionType> matcherProtection, Integer cryptoStrength, Set<AttachmentHint> attachmentHint, @NonNull Set<TransactionConfirmationDisplayType> tcDisplay, String tcDisplayContentType, List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics, @NonNull Set<X509Certificate> attestationRootCertificates, String icon, Set<ExtensionDescriptor> supportedExtensions, AuthenticatorGetInfo authenticatorGetInfo) {
        if (protocolFamily == null) {
            throw new NullPointerException("protocolFamily is marked non-null but is null");
        }
        if (upv == null) {
            throw new NullPointerException("upv is marked non-null but is null");
        }
        if (authenticationAlgorithms == null) {
            throw new NullPointerException("authenticationAlgorithms is marked non-null but is null");
        }
        if (publicKeyAlgAndEncodings == null) {
            throw new NullPointerException("publicKeyAlgAndEncodings is marked non-null but is null");
        }
        if (attestationTypes == null) {
            throw new NullPointerException("attestationTypes is marked non-null but is null");
        }
        if (userVerificationDetails == null) {
            throw new NullPointerException("userVerificationDetails is marked non-null but is null");
        }
        if (keyProtection == null) {
            throw new NullPointerException("keyProtection is marked non-null but is null");
        }
        if (matcherProtection == null) {
            throw new NullPointerException("matcherProtection is marked non-null but is null");
        }
        if (tcDisplay == null) {
            throw new NullPointerException("tcDisplay is marked non-null but is null");
        }
        if (attestationRootCertificates == null) {
            throw new NullPointerException("attestationRootCertificates is marked non-null but is null");
        }
        this.legalHeader = legalHeader;
        this.aaid = aaid;
        this.aaguid = aaguid;
        this.attestationCertificateKeyIdentifiers = CollectionUtil.immutableSetOrEmpty(attestationCertificateKeyIdentifiers);
        this.description = description;
        this.alternativeDescriptions = alternativeDescriptions;
        this.authenticatorVersion = authenticatorVersion;
        this.protocolFamily = protocolFamily;
        this.schema = schema;
        this.upv = upv;
        this.authenticationAlgorithms = authenticationAlgorithms;
        this.publicKeyAlgAndEncodings = publicKeyAlgAndEncodings;
        this.attestationTypes = attestationTypes;
        this.userVerificationDetails = userVerificationDetails;
        this.keyProtection = keyProtection;
        this.isKeyRestricted = isKeyRestricted;
        this.isFreshUserVerificationRequired = isFreshUserVerificationRequired;
        this.matcherProtection = matcherProtection;
        this.cryptoStrength = cryptoStrength;
        this.attachmentHint = attachmentHint;
        this.tcDisplay = tcDisplay;
        this.tcDisplayContentType = tcDisplayContentType;
        this.tcDisplayPNGCharacteristics = tcDisplayPNGCharacteristics;
        this.attestationRootCertificates = attestationRootCertificates;
        this.icon = icon;
        this.supportedExtensions = supportedExtensions;
        this.authenticatorGetInfo = authenticatorGetInfo;
    }

    public Optional<String> getLegalHeader() {
        return Optional.ofNullable(this.legalHeader);
    }

    public Optional<AAID> getAaid() {
        return Optional.ofNullable(this.aaid);
    }

    public Optional<AAGUID> getAaguid() {
        return Optional.ofNullable(this.aaguid);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<AlternativeDescriptions> getAlternativeDescriptions() {
        return Optional.ofNullable(this.alternativeDescriptions);
    }

    public Optional<Boolean> getIsKeyRestricted() {
        return Optional.ofNullable(this.isKeyRestricted);
    }

    public Optional<Boolean> getIsFreshUserVerificationRequired() {
        return Optional.ofNullable(this.isFreshUserVerificationRequired);
    }

    public Optional<Integer> getCryptoStrength() {
        return Optional.ofNullable(this.cryptoStrength);
    }

    public Optional<Set<AttachmentHint>> getAttachmentHint() {
        return Optional.ofNullable(this.attachmentHint);
    }

    public Optional<String> getTcDisplayContentType() {
        return Optional.ofNullable(this.tcDisplayContentType);
    }

    public Optional<List<DisplayPNGCharacteristicsDescriptor>> getTcDisplayPNGCharacteristics() {
        return Optional.ofNullable(this.tcDisplayPNGCharacteristics);
    }

    public Optional<String> getIcon() {
        return Optional.ofNullable(this.icon);
    }

    public Optional<Set<ExtensionDescriptor>> getSupportedExtensions() {
        return Optional.ofNullable(this.supportedExtensions);
    }

    public Optional<AuthenticatorGetInfo> getAuthenticatorGetInfo() {
        return Optional.ofNullable(this.authenticatorGetInfo);
    }

    @Generated
    public static MetadataStatementBuilder builder() {
        return new MetadataStatementBuilder();
    }

    @Generated
    public MetadataStatementBuilder toBuilder() {
        return new MetadataStatementBuilder().legalHeader(this.legalHeader).aaid(this.aaid).aaguid(this.aaguid).attestationCertificateKeyIdentifiers(this.attestationCertificateKeyIdentifiers).description(this.description).alternativeDescriptions(this.alternativeDescriptions).authenticatorVersion(this.authenticatorVersion).protocolFamily(this.protocolFamily).schema(this.schema).upv(this.upv).authenticationAlgorithms(this.authenticationAlgorithms).publicKeyAlgAndEncodings(this.publicKeyAlgAndEncodings).attestationTypes(this.attestationTypes).userVerificationDetails(this.userVerificationDetails).keyProtection(this.keyProtection).isKeyRestricted(this.isKeyRestricted).isFreshUserVerificationRequired(this.isFreshUserVerificationRequired).matcherProtection(this.matcherProtection).cryptoStrength(this.cryptoStrength).attachmentHint(this.attachmentHint).tcDisplay(this.tcDisplay).tcDisplayContentType(this.tcDisplayContentType).tcDisplayPNGCharacteristics(this.tcDisplayPNGCharacteristics).attestationRootCertificates(this.attestationRootCertificates).icon(this.icon).supportedExtensions(this.supportedExtensions).authenticatorGetInfo(this.authenticatorGetInfo);
    }

    @Generated
    public Set<String> getAttestationCertificateKeyIdentifiers() {
        return this.attestationCertificateKeyIdentifiers;
    }

    @Generated
    public long getAuthenticatorVersion() {
        return this.authenticatorVersion;
    }

    @NonNull
    @Generated
    public ProtocolFamily getProtocolFamily() {
        return this.protocolFamily;
    }

    @Generated
    public int getSchema() {
        return this.schema;
    }

    @NonNull
    @Generated
    public Set<Version> getUpv() {
        return this.upv;
    }

    @NonNull
    @Generated
    public Set<AuthenticationAlgorithm> getAuthenticationAlgorithms() {
        return this.authenticationAlgorithms;
    }

    @NonNull
    @Generated
    public Set<PublicKeyRepresentationFormat> getPublicKeyAlgAndEncodings() {
        return this.publicKeyAlgAndEncodings;
    }

    @NonNull
    @Generated
    public Set<AuthenticatorAttestationType> getAttestationTypes() {
        return this.attestationTypes;
    }

    @NonNull
    @Generated
    public Set<Set<VerificationMethodDescriptor>> getUserVerificationDetails() {
        return this.userVerificationDetails;
    }

    @NonNull
    @Generated
    public Set<KeyProtectionType> getKeyProtection() {
        return this.keyProtection;
    }

    @NonNull
    @Generated
    public Set<MatcherProtectionType> getMatcherProtection() {
        return this.matcherProtection;
    }

    @NonNull
    @Generated
    public Set<TransactionConfirmationDisplayType> getTcDisplay() {
        return this.tcDisplay;
    }

    @NonNull
    @Generated
    public Set<X509Certificate> getAttestationRootCertificates() {
        return this.attestationRootCertificates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataStatement)) {
            return false;
        }
        MetadataStatement other = (MetadataStatement)o;
        if (this.getAuthenticatorVersion() != other.getAuthenticatorVersion()) {
            return false;
        }
        if (this.getSchema() != other.getSchema()) {
            return false;
        }
        Optional<Boolean> this$isKeyRestricted = this.getIsKeyRestricted();
        Optional<Boolean> other$isKeyRestricted = other.getIsKeyRestricted();
        if (this$isKeyRestricted == null ? other$isKeyRestricted != null : !((Object)this$isKeyRestricted).equals(other$isKeyRestricted)) {
            return false;
        }
        Optional<Boolean> this$isFreshUserVerificationRequired = this.getIsFreshUserVerificationRequired();
        Optional<Boolean> other$isFreshUserVerificationRequired = other.getIsFreshUserVerificationRequired();
        if (this$isFreshUserVerificationRequired == null ? other$isFreshUserVerificationRequired != null : !((Object)this$isFreshUserVerificationRequired).equals(other$isFreshUserVerificationRequired)) {
            return false;
        }
        Optional<Integer> this$cryptoStrength = this.getCryptoStrength();
        Optional<Integer> other$cryptoStrength = other.getCryptoStrength();
        if (this$cryptoStrength == null ? other$cryptoStrength != null : !((Object)this$cryptoStrength).equals(other$cryptoStrength)) {
            return false;
        }
        Optional<String> this$legalHeader = this.getLegalHeader();
        Optional<String> other$legalHeader = other.getLegalHeader();
        if (this$legalHeader == null ? other$legalHeader != null : !((Object)this$legalHeader).equals(other$legalHeader)) {
            return false;
        }
        Optional<AAID> this$aaid = this.getAaid();
        Optional<AAID> other$aaid = other.getAaid();
        if (this$aaid == null ? other$aaid != null : !((Object)this$aaid).equals(other$aaid)) {
            return false;
        }
        Optional<AAGUID> this$aaguid = this.getAaguid();
        Optional<AAGUID> other$aaguid = other.getAaguid();
        if (this$aaguid == null ? other$aaguid != null : !((Object)this$aaguid).equals(other$aaguid)) {
            return false;
        }
        Set<String> this$attestationCertificateKeyIdentifiers = this.getAttestationCertificateKeyIdentifiers();
        Set<String> other$attestationCertificateKeyIdentifiers = other.getAttestationCertificateKeyIdentifiers();
        if (this$attestationCertificateKeyIdentifiers == null ? other$attestationCertificateKeyIdentifiers != null : !((Object)this$attestationCertificateKeyIdentifiers).equals(other$attestationCertificateKeyIdentifiers)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        Optional<AlternativeDescriptions> this$alternativeDescriptions = this.getAlternativeDescriptions();
        Optional<AlternativeDescriptions> other$alternativeDescriptions = other.getAlternativeDescriptions();
        if (this$alternativeDescriptions == null ? other$alternativeDescriptions != null : !((Object)this$alternativeDescriptions).equals(other$alternativeDescriptions)) {
            return false;
        }
        ProtocolFamily this$protocolFamily = this.getProtocolFamily();
        ProtocolFamily other$protocolFamily = other.getProtocolFamily();
        if (this$protocolFamily == null ? other$protocolFamily != null : !((Object)((Object)this$protocolFamily)).equals((Object)other$protocolFamily)) {
            return false;
        }
        Set<Version> this$upv = this.getUpv();
        Set<Version> other$upv = other.getUpv();
        if (this$upv == null ? other$upv != null : !((Object)this$upv).equals(other$upv)) {
            return false;
        }
        Set<AuthenticationAlgorithm> this$authenticationAlgorithms = this.getAuthenticationAlgorithms();
        Set<AuthenticationAlgorithm> other$authenticationAlgorithms = other.getAuthenticationAlgorithms();
        if (this$authenticationAlgorithms == null ? other$authenticationAlgorithms != null : !((Object)this$authenticationAlgorithms).equals(other$authenticationAlgorithms)) {
            return false;
        }
        Set<PublicKeyRepresentationFormat> this$publicKeyAlgAndEncodings = this.getPublicKeyAlgAndEncodings();
        Set<PublicKeyRepresentationFormat> other$publicKeyAlgAndEncodings = other.getPublicKeyAlgAndEncodings();
        if (this$publicKeyAlgAndEncodings == null ? other$publicKeyAlgAndEncodings != null : !((Object)this$publicKeyAlgAndEncodings).equals(other$publicKeyAlgAndEncodings)) {
            return false;
        }
        Set<AuthenticatorAttestationType> this$attestationTypes = this.getAttestationTypes();
        Set<AuthenticatorAttestationType> other$attestationTypes = other.getAttestationTypes();
        if (this$attestationTypes == null ? other$attestationTypes != null : !((Object)this$attestationTypes).equals(other$attestationTypes)) {
            return false;
        }
        Set<Set<VerificationMethodDescriptor>> this$userVerificationDetails = this.getUserVerificationDetails();
        Set<Set<VerificationMethodDescriptor>> other$userVerificationDetails = other.getUserVerificationDetails();
        if (this$userVerificationDetails == null ? other$userVerificationDetails != null : !((Object)this$userVerificationDetails).equals(other$userVerificationDetails)) {
            return false;
        }
        Set<KeyProtectionType> this$keyProtection = this.getKeyProtection();
        Set<KeyProtectionType> other$keyProtection = other.getKeyProtection();
        if (this$keyProtection == null ? other$keyProtection != null : !((Object)this$keyProtection).equals(other$keyProtection)) {
            return false;
        }
        Set<MatcherProtectionType> this$matcherProtection = this.getMatcherProtection();
        Set<MatcherProtectionType> other$matcherProtection = other.getMatcherProtection();
        if (this$matcherProtection == null ? other$matcherProtection != null : !((Object)this$matcherProtection).equals(other$matcherProtection)) {
            return false;
        }
        Optional<Set<AttachmentHint>> this$attachmentHint = this.getAttachmentHint();
        Optional<Set<AttachmentHint>> other$attachmentHint = other.getAttachmentHint();
        if (this$attachmentHint == null ? other$attachmentHint != null : !((Object)this$attachmentHint).equals(other$attachmentHint)) {
            return false;
        }
        Set<TransactionConfirmationDisplayType> this$tcDisplay = this.getTcDisplay();
        Set<TransactionConfirmationDisplayType> other$tcDisplay = other.getTcDisplay();
        if (this$tcDisplay == null ? other$tcDisplay != null : !((Object)this$tcDisplay).equals(other$tcDisplay)) {
            return false;
        }
        Optional<String> this$tcDisplayContentType = this.getTcDisplayContentType();
        Optional<String> other$tcDisplayContentType = other.getTcDisplayContentType();
        if (this$tcDisplayContentType == null ? other$tcDisplayContentType != null : !((Object)this$tcDisplayContentType).equals(other$tcDisplayContentType)) {
            return false;
        }
        Optional<List<DisplayPNGCharacteristicsDescriptor>> this$tcDisplayPNGCharacteristics = this.getTcDisplayPNGCharacteristics();
        Optional<List<DisplayPNGCharacteristicsDescriptor>> other$tcDisplayPNGCharacteristics = other.getTcDisplayPNGCharacteristics();
        if (this$tcDisplayPNGCharacteristics == null ? other$tcDisplayPNGCharacteristics != null : !((Object)this$tcDisplayPNGCharacteristics).equals(other$tcDisplayPNGCharacteristics)) {
            return false;
        }
        Set<X509Certificate> this$attestationRootCertificates = this.getAttestationRootCertificates();
        Set<X509Certificate> other$attestationRootCertificates = other.getAttestationRootCertificates();
        if (this$attestationRootCertificates == null ? other$attestationRootCertificates != null : !((Object)this$attestationRootCertificates).equals(other$attestationRootCertificates)) {
            return false;
        }
        Optional<String> this$icon = this.getIcon();
        Optional<String> other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !((Object)this$icon).equals(other$icon)) {
            return false;
        }
        Optional<Set<ExtensionDescriptor>> this$supportedExtensions = this.getSupportedExtensions();
        Optional<Set<ExtensionDescriptor>> other$supportedExtensions = other.getSupportedExtensions();
        if (this$supportedExtensions == null ? other$supportedExtensions != null : !((Object)this$supportedExtensions).equals(other$supportedExtensions)) {
            return false;
        }
        Optional<AuthenticatorGetInfo> this$authenticatorGetInfo = this.getAuthenticatorGetInfo();
        Optional<AuthenticatorGetInfo> other$authenticatorGetInfo = other.getAuthenticatorGetInfo();
        return !(this$authenticatorGetInfo == null ? other$authenticatorGetInfo != null : !((Object)this$authenticatorGetInfo).equals(other$authenticatorGetInfo));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $authenticatorVersion = this.getAuthenticatorVersion();
        result = result * 59 + (int)($authenticatorVersion >>> 32 ^ $authenticatorVersion);
        result = result * 59 + this.getSchema();
        Optional<Boolean> $isKeyRestricted = this.getIsKeyRestricted();
        result = result * 59 + ($isKeyRestricted == null ? 43 : ((Object)$isKeyRestricted).hashCode());
        Optional<Boolean> $isFreshUserVerificationRequired = this.getIsFreshUserVerificationRequired();
        result = result * 59 + ($isFreshUserVerificationRequired == null ? 43 : ((Object)$isFreshUserVerificationRequired).hashCode());
        Optional<Integer> $cryptoStrength = this.getCryptoStrength();
        result = result * 59 + ($cryptoStrength == null ? 43 : ((Object)$cryptoStrength).hashCode());
        Optional<String> $legalHeader = this.getLegalHeader();
        result = result * 59 + ($legalHeader == null ? 43 : ((Object)$legalHeader).hashCode());
        Optional<AAID> $aaid = this.getAaid();
        result = result * 59 + ($aaid == null ? 43 : ((Object)$aaid).hashCode());
        Optional<AAGUID> $aaguid = this.getAaguid();
        result = result * 59 + ($aaguid == null ? 43 : ((Object)$aaguid).hashCode());
        Set<String> $attestationCertificateKeyIdentifiers = this.getAttestationCertificateKeyIdentifiers();
        result = result * 59 + ($attestationCertificateKeyIdentifiers == null ? 43 : ((Object)$attestationCertificateKeyIdentifiers).hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        Optional<AlternativeDescriptions> $alternativeDescriptions = this.getAlternativeDescriptions();
        result = result * 59 + ($alternativeDescriptions == null ? 43 : ((Object)$alternativeDescriptions).hashCode());
        ProtocolFamily $protocolFamily = this.getProtocolFamily();
        result = result * 59 + ($protocolFamily == null ? 43 : ((Object)((Object)$protocolFamily)).hashCode());
        Set<Version> $upv = this.getUpv();
        result = result * 59 + ($upv == null ? 43 : ((Object)$upv).hashCode());
        Set<AuthenticationAlgorithm> $authenticationAlgorithms = this.getAuthenticationAlgorithms();
        result = result * 59 + ($authenticationAlgorithms == null ? 43 : ((Object)$authenticationAlgorithms).hashCode());
        Set<PublicKeyRepresentationFormat> $publicKeyAlgAndEncodings = this.getPublicKeyAlgAndEncodings();
        result = result * 59 + ($publicKeyAlgAndEncodings == null ? 43 : ((Object)$publicKeyAlgAndEncodings).hashCode());
        Set<AuthenticatorAttestationType> $attestationTypes = this.getAttestationTypes();
        result = result * 59 + ($attestationTypes == null ? 43 : ((Object)$attestationTypes).hashCode());
        Set<Set<VerificationMethodDescriptor>> $userVerificationDetails = this.getUserVerificationDetails();
        result = result * 59 + ($userVerificationDetails == null ? 43 : ((Object)$userVerificationDetails).hashCode());
        Set<KeyProtectionType> $keyProtection = this.getKeyProtection();
        result = result * 59 + ($keyProtection == null ? 43 : ((Object)$keyProtection).hashCode());
        Set<MatcherProtectionType> $matcherProtection = this.getMatcherProtection();
        result = result * 59 + ($matcherProtection == null ? 43 : ((Object)$matcherProtection).hashCode());
        Optional<Set<AttachmentHint>> $attachmentHint = this.getAttachmentHint();
        result = result * 59 + ($attachmentHint == null ? 43 : ((Object)$attachmentHint).hashCode());
        Set<TransactionConfirmationDisplayType> $tcDisplay = this.getTcDisplay();
        result = result * 59 + ($tcDisplay == null ? 43 : ((Object)$tcDisplay).hashCode());
        Optional<String> $tcDisplayContentType = this.getTcDisplayContentType();
        result = result * 59 + ($tcDisplayContentType == null ? 43 : ((Object)$tcDisplayContentType).hashCode());
        Optional<List<DisplayPNGCharacteristicsDescriptor>> $tcDisplayPNGCharacteristics = this.getTcDisplayPNGCharacteristics();
        result = result * 59 + ($tcDisplayPNGCharacteristics == null ? 43 : ((Object)$tcDisplayPNGCharacteristics).hashCode());
        Set<X509Certificate> $attestationRootCertificates = this.getAttestationRootCertificates();
        result = result * 59 + ($attestationRootCertificates == null ? 43 : ((Object)$attestationRootCertificates).hashCode());
        Optional<String> $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : ((Object)$icon).hashCode());
        Optional<Set<ExtensionDescriptor>> $supportedExtensions = this.getSupportedExtensions();
        result = result * 59 + ($supportedExtensions == null ? 43 : ((Object)$supportedExtensions).hashCode());
        Optional<AuthenticatorGetInfo> $authenticatorGetInfo = this.getAuthenticatorGetInfo();
        result = result * 59 + ($authenticatorGetInfo == null ? 43 : ((Object)$authenticatorGetInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetadataStatement(legalHeader=" + this.getLegalHeader() + ", aaid=" + this.getAaid() + ", aaguid=" + this.getAaguid() + ", attestationCertificateKeyIdentifiers=" + this.getAttestationCertificateKeyIdentifiers() + ", description=" + this.getDescription() + ", alternativeDescriptions=" + this.getAlternativeDescriptions() + ", authenticatorVersion=" + this.getAuthenticatorVersion() + ", protocolFamily=" + (Object)((Object)this.getProtocolFamily()) + ", schema=" + this.getSchema() + ", upv=" + this.getUpv() + ", authenticationAlgorithms=" + this.getAuthenticationAlgorithms() + ", publicKeyAlgAndEncodings=" + this.getPublicKeyAlgAndEncodings() + ", attestationTypes=" + this.getAttestationTypes() + ", userVerificationDetails=" + this.getUserVerificationDetails() + ", keyProtection=" + this.getKeyProtection() + ", isKeyRestricted=" + this.getIsKeyRestricted() + ", isFreshUserVerificationRequired=" + this.getIsFreshUserVerificationRequired() + ", matcherProtection=" + this.getMatcherProtection() + ", cryptoStrength=" + this.getCryptoStrength() + ", attachmentHint=" + this.getAttachmentHint() + ", tcDisplay=" + this.getTcDisplay() + ", tcDisplayContentType=" + this.getTcDisplayContentType() + ", tcDisplayPNGCharacteristics=" + this.getTcDisplayPNGCharacteristics() + ", attestationRootCertificates=" + this.getAttestationRootCertificates() + ", icon=" + this.getIcon() + ", supportedExtensions=" + this.getSupportedExtensions() + ", authenticatorGetInfo=" + this.getAuthenticatorGetInfo() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class MetadataStatementBuilder {
        @Generated
        private String legalHeader;
        @Generated
        private AAID aaid;
        @Generated
        private AAGUID aaguid;
        @Generated
        private Set<String> attestationCertificateKeyIdentifiers;
        @Generated
        private String description;
        @Generated
        private AlternativeDescriptions alternativeDescriptions;
        @Generated
        private long authenticatorVersion;
        @Generated
        private ProtocolFamily protocolFamily;
        @Generated
        private int schema;
        @Generated
        private Set<Version> upv;
        @Generated
        private Set<AuthenticationAlgorithm> authenticationAlgorithms;
        @Generated
        private Set<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings;
        @Generated
        private Set<AuthenticatorAttestationType> attestationTypes;
        @Generated
        private Set<Set<VerificationMethodDescriptor>> userVerificationDetails;
        @Generated
        private Set<KeyProtectionType> keyProtection;
        @Generated
        private Boolean isKeyRestricted;
        @Generated
        private Boolean isFreshUserVerificationRequired;
        @Generated
        private Set<MatcherProtectionType> matcherProtection;
        @Generated
        private Integer cryptoStrength;
        @Generated
        private Set<AttachmentHint> attachmentHint;
        @Generated
        private Set<TransactionConfirmationDisplayType> tcDisplay;
        @Generated
        private String tcDisplayContentType;
        @Generated
        private List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics;
        @Generated
        private Set<X509Certificate> attestationRootCertificates;
        @Generated
        private String icon;
        @Generated
        private Set<ExtensionDescriptor> supportedExtensions;
        @Generated
        private AuthenticatorGetInfo authenticatorGetInfo;

        @Generated
        MetadataStatementBuilder() {
        }

        @Generated
        public MetadataStatementBuilder legalHeader(String legalHeader) {
            this.legalHeader = legalHeader;
            return this;
        }

        @Generated
        public MetadataStatementBuilder aaid(AAID aaid) {
            this.aaid = aaid;
            return this;
        }

        @Generated
        public MetadataStatementBuilder aaguid(AAGUID aaguid) {
            this.aaguid = aaguid;
            return this;
        }

        @Generated
        public MetadataStatementBuilder attestationCertificateKeyIdentifiers(Set<String> attestationCertificateKeyIdentifiers) {
            this.attestationCertificateKeyIdentifiers = attestationCertificateKeyIdentifiers;
            return this;
        }

        @Generated
        public MetadataStatementBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MetadataStatementBuilder alternativeDescriptions(AlternativeDescriptions alternativeDescriptions) {
            this.alternativeDescriptions = alternativeDescriptions;
            return this;
        }

        @Generated
        public MetadataStatementBuilder authenticatorVersion(long authenticatorVersion) {
            this.authenticatorVersion = authenticatorVersion;
            return this;
        }

        @Generated
        public MetadataStatementBuilder protocolFamily(@NonNull ProtocolFamily protocolFamily) {
            if (protocolFamily == null) {
                throw new NullPointerException("protocolFamily is marked non-null but is null");
            }
            this.protocolFamily = protocolFamily;
            return this;
        }

        @Generated
        public MetadataStatementBuilder schema(int schema) {
            this.schema = schema;
            return this;
        }

        @Generated
        public MetadataStatementBuilder upv(@NonNull Set<Version> upv) {
            if (upv == null) {
                throw new NullPointerException("upv is marked non-null but is null");
            }
            this.upv = upv;
            return this;
        }

        @Generated
        public MetadataStatementBuilder authenticationAlgorithms(@NonNull Set<AuthenticationAlgorithm> authenticationAlgorithms) {
            if (authenticationAlgorithms == null) {
                throw new NullPointerException("authenticationAlgorithms is marked non-null but is null");
            }
            this.authenticationAlgorithms = authenticationAlgorithms;
            return this;
        }

        @Generated
        public MetadataStatementBuilder publicKeyAlgAndEncodings(@NonNull Set<PublicKeyRepresentationFormat> publicKeyAlgAndEncodings) {
            if (publicKeyAlgAndEncodings == null) {
                throw new NullPointerException("publicKeyAlgAndEncodings is marked non-null but is null");
            }
            this.publicKeyAlgAndEncodings = publicKeyAlgAndEncodings;
            return this;
        }

        @Generated
        public MetadataStatementBuilder attestationTypes(@NonNull Set<AuthenticatorAttestationType> attestationTypes) {
            if (attestationTypes == null) {
                throw new NullPointerException("attestationTypes is marked non-null but is null");
            }
            this.attestationTypes = attestationTypes;
            return this;
        }

        @Generated
        public MetadataStatementBuilder userVerificationDetails(@NonNull Set<Set<VerificationMethodDescriptor>> userVerificationDetails) {
            if (userVerificationDetails == null) {
                throw new NullPointerException("userVerificationDetails is marked non-null but is null");
            }
            this.userVerificationDetails = userVerificationDetails;
            return this;
        }

        @Generated
        public MetadataStatementBuilder keyProtection(@NonNull Set<KeyProtectionType> keyProtection) {
            if (keyProtection == null) {
                throw new NullPointerException("keyProtection is marked non-null but is null");
            }
            this.keyProtection = keyProtection;
            return this;
        }

        @Generated
        public MetadataStatementBuilder isKeyRestricted(Boolean isKeyRestricted) {
            this.isKeyRestricted = isKeyRestricted;
            return this;
        }

        @Generated
        public MetadataStatementBuilder isFreshUserVerificationRequired(Boolean isFreshUserVerificationRequired) {
            this.isFreshUserVerificationRequired = isFreshUserVerificationRequired;
            return this;
        }

        @Generated
        public MetadataStatementBuilder matcherProtection(@NonNull Set<MatcherProtectionType> matcherProtection) {
            if (matcherProtection == null) {
                throw new NullPointerException("matcherProtection is marked non-null but is null");
            }
            this.matcherProtection = matcherProtection;
            return this;
        }

        @Generated
        public MetadataStatementBuilder cryptoStrength(Integer cryptoStrength) {
            this.cryptoStrength = cryptoStrength;
            return this;
        }

        @Generated
        public MetadataStatementBuilder attachmentHint(Set<AttachmentHint> attachmentHint) {
            this.attachmentHint = attachmentHint;
            return this;
        }

        @Generated
        public MetadataStatementBuilder tcDisplay(@NonNull Set<TransactionConfirmationDisplayType> tcDisplay) {
            if (tcDisplay == null) {
                throw new NullPointerException("tcDisplay is marked non-null but is null");
            }
            this.tcDisplay = tcDisplay;
            return this;
        }

        @Generated
        public MetadataStatementBuilder tcDisplayContentType(String tcDisplayContentType) {
            this.tcDisplayContentType = tcDisplayContentType;
            return this;
        }

        @Generated
        public MetadataStatementBuilder tcDisplayPNGCharacteristics(List<DisplayPNGCharacteristicsDescriptor> tcDisplayPNGCharacteristics) {
            this.tcDisplayPNGCharacteristics = tcDisplayPNGCharacteristics;
            return this;
        }

        @JsonDeserialize(contentConverter=CertFromBase64Converter.class)
        @Generated
        public MetadataStatementBuilder attestationRootCertificates(@NonNull Set<X509Certificate> attestationRootCertificates) {
            if (attestationRootCertificates == null) {
                throw new NullPointerException("attestationRootCertificates is marked non-null but is null");
            }
            this.attestationRootCertificates = attestationRootCertificates;
            return this;
        }

        @Generated
        public MetadataStatementBuilder icon(String icon) {
            this.icon = icon;
            return this;
        }

        @Generated
        public MetadataStatementBuilder supportedExtensions(Set<ExtensionDescriptor> supportedExtensions) {
            this.supportedExtensions = supportedExtensions;
            return this;
        }

        @Generated
        public MetadataStatementBuilder authenticatorGetInfo(AuthenticatorGetInfo authenticatorGetInfo) {
            this.authenticatorGetInfo = authenticatorGetInfo;
            return this;
        }

        @Generated
        public MetadataStatement build() {
            return new MetadataStatement(this.legalHeader, this.aaid, this.aaguid, this.attestationCertificateKeyIdentifiers, this.description, this.alternativeDescriptions, this.authenticatorVersion, this.protocolFamily, this.schema, this.upv, this.authenticationAlgorithms, this.publicKeyAlgAndEncodings, this.attestationTypes, this.userVerificationDetails, this.keyProtection, this.isKeyRestricted, this.isFreshUserVerificationRequired, this.matcherProtection, this.cryptoStrength, this.attachmentHint, this.tcDisplay, this.tcDisplayContentType, this.tcDisplayPNGCharacteristics, this.attestationRootCertificates, this.icon, this.supportedExtensions, this.authenticatorGetInfo);
        }

        @Generated
        public String toString() {
            return "MetadataStatement.MetadataStatementBuilder(legalHeader=" + this.legalHeader + ", aaid=" + this.aaid + ", aaguid=" + this.aaguid + ", attestationCertificateKeyIdentifiers=" + this.attestationCertificateKeyIdentifiers + ", description=" + this.description + ", alternativeDescriptions=" + this.alternativeDescriptions + ", authenticatorVersion=" + this.authenticatorVersion + ", protocolFamily=" + (Object)((Object)this.protocolFamily) + ", schema=" + this.schema + ", upv=" + this.upv + ", authenticationAlgorithms=" + this.authenticationAlgorithms + ", publicKeyAlgAndEncodings=" + this.publicKeyAlgAndEncodings + ", attestationTypes=" + this.attestationTypes + ", userVerificationDetails=" + this.userVerificationDetails + ", keyProtection=" + this.keyProtection + ", isKeyRestricted=" + this.isKeyRestricted + ", isFreshUserVerificationRequired=" + this.isFreshUserVerificationRequired + ", matcherProtection=" + this.matcherProtection + ", cryptoStrength=" + this.cryptoStrength + ", attachmentHint=" + this.attachmentHint + ", tcDisplay=" + this.tcDisplay + ", tcDisplayContentType=" + this.tcDisplayContentType + ", tcDisplayPNGCharacteristics=" + this.tcDisplayPNGCharacteristics + ", attestationRootCertificates=" + this.attestationRootCertificates + ", icon=" + this.icon + ", supportedExtensions=" + this.supportedExtensions + ", authenticatorGetInfo=" + this.authenticatorGetInfo + ")";
        }
    }
}

