/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service;

import com.google.common.annotations.VisibleForTesting;
import com.wavefront.sdk.common.Utils;
import com.wavefront.sdk.common.clients.service.ReportAPI;
import com.wavefront.sdk.common.clients.service.token.TokenService;
import com.wavefront.sdk.common.logging.MessageSuppressingLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public class ReportingService
implements ReportAPI {
    private final MessageSuppressingLogger messageSuppressingLogger;
    private final TokenService tokenService;
    private final URI uri;
    private static final int CONNECT_TIMEOUT_MILLIS = 30000;
    private static final int READ_TIMEOUT_MILLIS = 10000;
    private static final int BUFFER_SIZE = 4096;
    private static final int NO_HTTP_RESPONSE = -1;

    public ReportingService(URI uri, TokenService tokenService, long reportingServiceLogSuppressTimeSeconds) {
        this.uri = uri;
        this.tokenService = tokenService;
        reportingServiceLogSuppressTimeSeconds = reportingServiceLogSuppressTimeSeconds <= 0L ? 1L : reportingServiceLogSuppressTimeSeconds;
        this.messageSuppressingLogger = new MessageSuppressingLogger(Logger.getLogger(ReportingService.class.getCanonicalName()), reportingServiceLogSuppressTimeSeconds, TimeUnit.SECONDS);
    }

    @Override
    public int send(String format, InputStream stream) {
        int statusCode;
        block17: {
            HttpURLConnection urlConn = null;
            statusCode = 400;
            try {
                URL url = ReportingService.getReportingUrl(this.uri, format);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("POST");
                urlConn.addRequestProperty("Content-Type", "application/octet-stream");
                urlConn.addRequestProperty("Content-Encoding", "gzip");
                String token = this.tokenService.getToken();
                if (!Utils.isNullOrEmpty(token)) {
                    urlConn.addRequestProperty("Authorization", "Bearer " + token);
                }
                urlConn.setConnectTimeout(30000);
                urlConn.setReadTimeout(10000);
                try (GZIPOutputStream gzipOS = new GZIPOutputStream(urlConn.getOutputStream());){
                    byte[] buffer = new byte[4096];
                    while (stream.available() > 0) {
                        gzipOS.write(buffer, 0, stream.read(buffer));
                    }
                    gzipOS.flush();
                }
                statusCode = urlConn.getResponseCode();
                this.readAndClose(urlConn.getInputStream());
                this.messageSuppressingLogger.reset(urlConn.getURL().toString());
            }
            catch (IOException ex) {
                if (urlConn == null) break block17;
                return this.safeGetResponseCodeAndClose(urlConn);
            }
        }
        return statusCode;
    }

    @Override
    public int sendEvent(InputStream stream) {
        int statusCode;
        block31: {
            HttpURLConnection urlConn = null;
            statusCode = 400;
            try {
                URL url = ReportingService.getEventReportingUrl(this.uri);
                urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setDoOutput(true);
                urlConn.setRequestMethod("POST");
                String token = this.tokenService.getToken();
                if (!Utils.isNullOrEmpty(token)) {
                    urlConn.addRequestProperty("Authorization", "Bearer " + token);
                }
                urlConn.setConnectTimeout(30000);
                urlConn.setReadTimeout(10000);
                if (this.uri.getScheme().equals("http")) {
                    urlConn.addRequestProperty("Content-Type", "application/octet-stream");
                    urlConn.addRequestProperty("Content-Encoding", "gzip");
                    try (GZIPOutputStream gzipOS = new GZIPOutputStream(urlConn.getOutputStream());){
                        byte[] buffer = new byte[4096];
                        while (stream.available() > 0) {
                            gzipOS.write(buffer, 0, stream.read(buffer));
                        }
                        gzipOS.flush();
                    }
                }
                urlConn.addRequestProperty("Content-Type", "application/json");
                try (OutputStream urlOS = urlConn.getOutputStream();){
                    byte[] buffer = new byte[4096];
                    while (stream.available() > 0) {
                        urlOS.write(buffer, 0, stream.read(buffer));
                    }
                    urlOS.flush();
                }
                statusCode = urlConn.getResponseCode();
                this.readAndClose(urlConn.getInputStream());
                this.messageSuppressingLogger.reset(urlConn.getURL().toString());
            }
            catch (IOException ex) {
                if (urlConn == null) break block31;
                return this.safeGetResponseCodeAndClose(urlConn);
            }
        }
        return statusCode;
    }

    private int safeGetResponseCodeAndClose(HttpURLConnection urlConn) {
        int statusCode;
        try {
            statusCode = urlConn.getResponseCode();
        }
        catch (IOException ex) {
            this.messageSuppressingLogger.log(urlConn.getURL().toString(), Level.SEVERE, "Unable to obtain status code from the Wavefront service at " + urlConn.getURL().toString() + " due to: " + ex);
            statusCode = -1;
        }
        try {
            this.readAndClose(urlConn.getErrorStream());
        }
        catch (IOException ex) {
            this.messageSuppressingLogger.log(urlConn.getURL().toString(), Level.SEVERE, "Unable to read and close error stream from the Wavefront service at " + urlConn.getURL().toString() + " due to: " + ex);
        }
        return statusCode;
    }

    private void readAndClose(InputStream stream) throws IOException {
        if (stream != null) {
            try (InputStream is = stream;){
                byte[] buffer = new byte[4096];
                while (is.read(buffer) > 0) {
                }
            }
        }
    }

    @VisibleForTesting
    public static URL getReportingUrl(URI server, String format) throws MalformedURLException {
        String originalPath = server.getPath() != null ? server.getPath() : "";
        originalPath = originalPath.replaceAll("(\\/){2,}", "/");
        String string = originalPath = originalPath.equals("/") ? "" : originalPath;
        if (originalPath.endsWith("/report/")) {
            originalPath = originalPath.replaceAll("/report/$", "/report");
        } else if (!originalPath.endsWith("/report")) {
            originalPath = originalPath + "/report";
        }
        URL url = new URL(server.getScheme(), server.getHost(), server.getPort(), originalPath + "?f=" + format);
        return url;
    }

    @VisibleForTesting
    public static URL getEventReportingUrl(URI server) throws MalformedURLException {
        String originalPath = server.getPath() != null ? server.getPath() : "";
        originalPath = originalPath.replaceAll("(\\/){2,}", "/");
        String string = originalPath = originalPath.equals("/") ? "" : originalPath;
        if (originalPath.endsWith("/api/v2/event/")) {
            originalPath = originalPath.replaceAll("\\/api\\/v2\\/event\\/$", "/api/v2/event");
        } else if (!originalPath.endsWith("/api/v2/event")) {
            originalPath = originalPath + "/api/v2/event";
        }
        URL url = new URL(server.getScheme(), server.getHost(), server.getPort(), originalPath);
        return url;
    }
}

