/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.clients.service.token;

import com.wavefront.sdk.common.annotation.Nullable;
import com.wavefront.sdk.common.clients.service.token.CSPServerTokenURLConnectionFactory;
import com.wavefront.sdk.common.clients.service.token.CSPTokenService;
import com.wavefront.sdk.common.clients.service.token.CSPUserTokenURLConnectionFactory;
import com.wavefront.sdk.common.clients.service.token.NoopProxyTokenService;
import com.wavefront.sdk.common.clients.service.token.TokenService;
import com.wavefront.sdk.common.clients.service.token.WavefrontTokenService;

public class TokenServiceFactory {
    public static TokenService create(TokenService.Type type, String token, @Nullable String cspBaseURL) {
        switch (type) {
            case CSP_API_TOKEN: {
                return new CSPTokenService(new CSPUserTokenURLConnectionFactory(cspBaseURL, token));
            }
            case CSP_CLIENT_CREDENTIALS: {
                return new CSPTokenService(new CSPServerTokenURLConnectionFactory(token));
            }
            case WAVEFRONT_API_TOKEN: {
                return new WavefrontTokenService(token);
            }
            case NO_TOKEN: {
                return new NoopProxyTokenService();
            }
        }
        return new NoopProxyTokenService();
    }
}

