/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.web.flow;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.webflow.execution.RequestContext;

public class WebAuthnPopulateCsrfTokenAction
extends ConsumerExecutionAction {
    public WebAuthnPopulateCsrfTokenAction(CsrfTokenRepository csrfTokenRepository) {
        super(context -> {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
            request.setAttribute(HttpServletResponse.class.getName(), (Object)response);
            CsrfToken csrfToken = csrfTokenRepository.loadToken(request);
            if (csrfToken == null) {
                csrfToken = csrfTokenRepository.generateToken(request);
                csrfTokenRepository.saveToken(csrfToken, request, response);
            }
            context.getFlowScope().put(csrfToken.getParameterName(), (Object)csrfToken);
        });
    }
}

