/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.util;

import com.signalfx.shaded.jetty.util.AbstractTrie;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeTrie<V>
extends AbstractTrie<V> {
    private static final int[] LOOKUP = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private static final int INDEX = 32;
    private final TreeTrie<V>[] _nextIndex;
    private final List<TreeTrie<V>> _nextOther = new ArrayList<TreeTrie<V>>();
    private final char _c;
    private String _key;
    private V _value;

    public TreeTrie() {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = '\u0000';
    }

    private TreeTrie(char c) {
        super(true);
        this._nextIndex = new TreeTrie[32];
        this._c = c;
    }

    @Override
    public void clear() {
        Arrays.fill(this._nextIndex, null);
        this._nextOther.clear();
        this._key = null;
        this._value = null;
    }

    @Override
    public boolean put(String s2, V v) {
        TreeTrie<V> t2 = this;
        int limit = s2.length();
        for (int k = 0; k < limit; ++k) {
            int index;
            char c = s2.charAt(k);
            int n = index = c >= '\u0000' && c < '\u007f' ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) {
                    t2._nextIndex[index] = new TreeTrie<V>(c);
                }
                t2 = t2._nextIndex[index];
                continue;
            }
            TreeTrie<V> n2 = null;
            int i = t2._nextOther.size();
            while (i-- > 0) {
                n2 = t2._nextOther.get(i);
                if (n2._c == c) break;
                n2 = null;
            }
            if (n2 == null) {
                n2 = new TreeTrie<V>(c);
                t2._nextOther.add(n2);
            }
            t2 = n2;
        }
        t2._key = v == null ? null : s2;
        t2._value = v;
        return true;
    }

    @Override
    public V get(String s2, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i = 0; i < len; ++i) {
            int index;
            char c = s2.charAt(offset + i);
            int n = index = c >= '\u0000' && c < '\u007f' ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) {
                    return null;
                }
                t2 = t2._nextIndex[index];
                continue;
            }
            TreeTrie<V> n2 = null;
            int j = t2._nextOther.size();
            while (j-- > 0) {
                n2 = t2._nextOther.get(j);
                if (n2._c == c) break;
                n2 = null;
            }
            if (n2 == null) {
                return null;
            }
            t2 = n2;
        }
        return t2._value;
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i = 0; i < len; ++i) {
            int index;
            byte c = b.get(offset + i);
            int n = index = c >= 0 && c < 127 ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) {
                    return null;
                }
                t2 = t2._nextIndex[index];
                continue;
            }
            TreeTrie<V> n2 = null;
            int j = t2._nextOther.size();
            while (j-- > 0) {
                n2 = t2._nextOther.get(j);
                if (n2._c == c) break;
                n2 = null;
            }
            if (n2 == null) {
                return null;
            }
            t2 = n2;
        }
        return t2._value;
    }

    @Override
    public V getBest(byte[] b, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i = 0; i < len; ++i) {
            int index;
            byte c = b[offset + i];
            int n = index = c >= 0 && c < 127 ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) break;
                t2 = t2._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t2._nextOther.size();
                while (j-- > 0) {
                    n2 = t2._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) break;
                t2 = n2;
            }
            if (t2._key == null) continue;
            V best = t2.getBest(b, offset + i + 1, len - i - 1);
            if (best == null) break;
            return best;
        }
        return t2._value;
    }

    @Override
    public V getBest(String s2, int offset, int len) {
        TreeTrie<V> t2 = this;
        for (int i = 0; i < len; ++i) {
            int index;
            byte c = (byte)(0xFF & s2.charAt(offset + i));
            int n = index = c >= 0 && c < 127 ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) break;
                t2 = t2._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t2._nextOther.size();
                while (j-- > 0) {
                    n2 = t2._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) break;
                t2 = n2;
            }
            if (t2._key == null) continue;
            V best = t2.getBest(s2, offset + i + 1, len - i - 1);
            if (best == null) break;
            return best;
        }
        return t2._value;
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest(b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBestByteBuffer(b, offset, len);
    }

    private V getBestByteBuffer(ByteBuffer b, int offset, int len) {
        TreeTrie<V> t2 = this;
        int pos = b.position() + offset;
        for (int i = 0; i < len; ++i) {
            byte c;
            int index;
            int n = index = (c = b.get(pos++)) >= 0 && c < 127 ? LOOKUP[c] : -1;
            if (index >= 0) {
                if (t2._nextIndex[index] == null) break;
                t2 = t2._nextIndex[index];
            } else {
                TreeTrie<V> n2 = null;
                int j = t2._nextOther.size();
                while (j-- > 0) {
                    n2 = t2._nextOther.get(j);
                    if (n2._c == c) break;
                    n2 = null;
                }
                if (n2 == null) break;
                t2 = n2;
            }
            if (t2._key == null) continue;
            V best = t2.getBest(b, offset + i + 1, len - i - 1);
            if (best == null) break;
            return best;
        }
        return t2._value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        TreeTrie.toString(buf, this);
        if (buf.length() == 0) {
            return "{}";
        }
        buf.setCharAt(0, '{');
        buf.append('}');
        return buf.toString();
    }

    private static <V> void toString(Appendable out, TreeTrie<V> t2) {
        if (t2 != null) {
            int i;
            if (t2._value != null) {
                try {
                    out.append(',');
                    out.append(t2._key);
                    out.append('=');
                    out.append(t2._value.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (i = 0; i < 32; ++i) {
                if (t2._nextIndex[i] == null) continue;
                TreeTrie.toString(out, t2._nextIndex[i]);
            }
            i = t2._nextOther.size();
            while (i-- > 0) {
                TreeTrie.toString(out, t2._nextOther.get(i));
            }
        }
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        TreeTrie.keySet(keys, this);
        return keys;
    }

    private static <V> void keySet(Set<String> set, TreeTrie<V> t2) {
        if (t2 != null) {
            int i;
            if (t2._key != null) {
                set.add(t2._key);
            }
            for (i = 0; i < 32; ++i) {
                if (t2._nextIndex[i] == null) continue;
                TreeTrie.keySet(set, t2._nextIndex[i]);
            }
            i = t2._nextOther.size();
            while (i-- > 0) {
                TreeTrie.keySet(set, t2._nextOther.get(i));
            }
        }
    }

    @Override
    public boolean isFull() {
        return false;
    }
}

