/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.http;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.FutureRequestExecutionService;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpClient;
import org.apereo.cas.util.http.SimpleHttpClientFactoryBean;
import org.apereo.cas.web.HttpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class SimpleHttpClient
extends Record
implements HttpClient,
Serializable,
DisposableBean {
    private final List<Integer> acceptableCodes;
    private final CloseableHttpClient wrappedHttpClient;
    private final FutureRequestExecutionService requestExecutorService;
    private final SimpleHttpClientFactoryBean httpClientFactory;
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHttpClient.class);
    private static final long serialVersionUID = -4949380008568071855L;

    public SimpleHttpClient(List<Integer> acceptableCodes, CloseableHttpClient wrappedHttpClient, FutureRequestExecutionService requestExecutorService, SimpleHttpClientFactoryBean httpClientFactory) {
        this.acceptableCodes = acceptableCodes;
        this.wrappedHttpClient = wrappedHttpClient;
        this.requestExecutorService = requestExecutorService;
        this.httpClientFactory = httpClientFactory;
    }

    @Override
    public boolean sendMessageToEndPoint(HttpMessage message) {
        try {
            HttpPost request = new HttpPost(message.getUrl().toURI());
            request.addHeader("Content-Type", (Object)message.getContentType());
            StringEntity entity = new StringEntity(message.getMessage(), ContentType.create((String)message.getContentType()));
            request.setEntity((HttpEntity)entity);
            HttpClientResponseHandler handler = response -> response.getCode() == 200;
            LOGGER.trace("Created HTTP post message payload [{}]", (Object)request);
            FutureTask task = this.requestExecutorService.execute((ClassicHttpRequest)request, (HttpContext)HttpClientContext.create(), handler);
            return message.isAsynchronous() || (Boolean)task.get() != false;
        }
        catch (RejectedExecutionException e) {
            LoggingUtils.warn(LOGGER, e);
            return false;
        }
        catch (Exception e) {
            LOGGER.debug("Unable to send message", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HttpMessage sendMessageToEndPoint(URL url) {
        try {
            CloseableHttpResponse response = this.wrappedHttpClient.execute((ClassicHttpRequest)new HttpGet(url.toURI()));
            int responseCode = response.getCode();
            for (Integer acceptableCode : this.acceptableCodes) {
                if (responseCode != acceptableCode) continue;
                LOGGER.debug("Response code received from server matched [{}].", (Object)responseCode);
                HttpEntity entity = response.getEntity();
                try {
                    HttpMessage msg = new HttpMessage(url, IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8));
                    msg.setContentType(entity.getContentType());
                    msg.setResponseCode(responseCode);
                    HttpMessage httpMessage = msg;
                    return httpMessage;
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)entity);
                }
            }
            LOGGER.warn("Response code [{}] from [{}] did not match any of the acceptable response codes.", (Object)responseCode, (Object)url);
            if (responseCode != 500) return null;
            String value = response.getReasonPhrase();
            LOGGER.error("There was an error contacting the endpoint: [{}]; The error:\n[{}]", (Object)url.toExternalForm(), (Object)value);
            return null;
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (Exception e) {
            LoggingUtils.error(LOGGER, e);
        }
        return null;
    }

    @Override
    public boolean isValidEndPoint(String url) {
        try {
            URL u = new URI(url).toURL();
            return this.isValidEndPoint(u);
        }
        catch (Exception e) {
            LoggingUtils.error(LOGGER, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValidEndPoint(URL url) {
        try (CloseableHttpResponse response = this.wrappedHttpClient.execute((ClassicHttpRequest)new HttpGet(url.toURI()));){
            int responseCode = response.getCode();
            int idx = Collections.binarySearch(this.acceptableCodes, responseCode);
            if (idx >= 0) {
                LOGGER.debug("Response code from server matched [{}].", (Object)responseCode);
                boolean bl = true;
                return bl;
            }
            LOGGER.debug("Response code did not match any of the acceptable response codes. Code returned was [{}]", (Object)responseCode);
            if (responseCode == 500) {
                String value = response.getReasonPhrase();
                LOGGER.error("There was an error contacting the endpoint: [{}]; The error was:\n[{}]", (Object)url.toExternalForm(), (Object)value);
            }
            HttpEntity entity = response.getEntity();
            try {
                LOGGER.debug("Located entity with length [{}]", (Object)entity.getContentLength());
                return false;
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            LoggingUtils.error(LOGGER, e);
        }
        return false;
    }

    public void destroy() {
        IOUtils.closeQuietly((Closeable)this.wrappedHttpClient);
        IOUtils.closeQuietly((Closeable)this.requestExecutorService);
        this.httpClientFactory.destroy();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SimpleHttpClient.class, "acceptableCodes;wrappedHttpClient;requestExecutorService;httpClientFactory", "acceptableCodes", "wrappedHttpClient", "requestExecutorService", "httpClientFactory"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SimpleHttpClient.class, "acceptableCodes;wrappedHttpClient;requestExecutorService;httpClientFactory", "acceptableCodes", "wrappedHttpClient", "requestExecutorService", "httpClientFactory"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SimpleHttpClient.class, "acceptableCodes;wrappedHttpClient;requestExecutorService;httpClientFactory", "acceptableCodes", "wrappedHttpClient", "requestExecutorService", "httpClientFactory"}, this, o);
    }

    public List<Integer> acceptableCodes() {
        return this.acceptableCodes;
    }

    public CloseableHttpClient wrappedHttpClient() {
        return this.wrappedHttpClient;
    }

    public FutureRequestExecutionService requestExecutorService() {
        return this.requestExecutorService;
    }

    @Override
    public SimpleHttpClientFactoryBean httpClientFactory() {
        return this.httpClientFactory;
    }
}

