/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;

@JsonPropertyOrder(value={"_class", "username"})
@Schema(allOf={AnyCR.class})
public class UserCR
extends AnyCR
implements GroupableRelatableTO {
    private static final long serialVersionUID = 2808404532469484940L;
    private String username;
    private String password;
    private boolean storePassword = true;
    private String securityQuestion;
    private String securityAnswer;
    private boolean mustChangePassword;
    private final List<MembershipTO> memberships = new ArrayList<MembershipTO>();
    private final Set<String> roles = new HashSet<String>();
    private final List<LinkedAccountTO> linkedAccounts = new ArrayList<LinkedAccountTO>();

    @Override
    @JacksonXmlProperty(localName="_class", isAttribute=true)
    @JsonProperty(value="_class")
    @Schema(name="_class", requiredMode=Schema.RequiredMode.REQUIRED, example="org.apache.syncope.common.lib.request.UserCR")
    public String getDiscriminator() {
        return this.getClass().getName();
    }

    @JsonProperty(required=true)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(boolean storePassword) {
        this.storePassword = storePassword;
    }

    public String getSecurityQuestion() {
        return this.securityQuestion;
    }

    public void setSecurityQuestion(String securityQuestion) {
        this.securityQuestion = securityQuestion;
    }

    public String getSecurityAnswer() {
        return this.securityAnswer;
    }

    public void setSecurityAnswer(String securityAnswer) {
        this.securityAnswer = securityAnswer;
    }

    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    @Override
    @JsonIgnore
    public Optional<MembershipTO> getMembership(String groupKey) {
        return this.memberships.stream().filter(membership -> groupKey.equals(membership.getGroupKey())).findFirst();
    }

    @Override
    @JacksonXmlElementWrapper(localName="memberships")
    @JacksonXmlProperty(localName="membership")
    public List<MembershipTO> getMemberships() {
        return this.memberships;
    }

    @Override
    @JsonIgnore
    public List<MembershipTO> getDynMemberships() {
        return List.of();
    }

    @JacksonXmlElementWrapper(localName="roles")
    @JacksonXmlProperty(localName="role")
    public Set<String> getRoles() {
        return this.roles;
    }

    @JacksonXmlElementWrapper(localName="linkedAccounts")
    @JacksonXmlProperty(localName="linkedAccount")
    public List<LinkedAccountTO> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.username).append(this.roles).append((Object)this.securityQuestion).append((Object)this.securityAnswer).append(this.mustChangePassword).append(this.memberships).append(this.linkedAccounts).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserCR other = (UserCR)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.username, (Object)other.username).append(this.roles, other.roles).append((Object)this.securityQuestion, (Object)other.securityQuestion).append((Object)this.securityAnswer, (Object)other.securityAnswer).append(this.mustChangePassword, other.mustChangePassword).append(this.memberships, other.memberships).append(this.linkedAccounts, other.linkedAccounts).build();
    }

    public static class Builder
    extends AnyCR.Builder<UserCR, Builder> {
        public Builder(String realm, String username) {
            super(realm);
            ((UserCR)this.getInstance()).setUsername(username);
        }

        @Override
        protected UserCR newInstance() {
            return new UserCR();
        }

        public Builder password(String password) {
            ((UserCR)this.getInstance()).setPassword(password);
            return this;
        }

        public Builder storePassword(boolean storePassword) {
            ((UserCR)this.getInstance()).setStorePassword(storePassword);
            return this;
        }

        public Builder securityQuestion(String securityQuestion) {
            ((UserCR)this.getInstance()).setSecurityQuestion(securityQuestion);
            return this;
        }

        public Builder securityAnswer(String securityAnswer) {
            ((UserCR)this.getInstance()).setSecurityAnswer(securityAnswer);
            return this;
        }

        public Builder mustChangePassword(boolean mustChangePassword) {
            ((UserCR)this.getInstance()).setMustChangePassword(mustChangePassword);
            return this;
        }

        public Builder membership(MembershipTO membership) {
            ((UserCR)this.getInstance()).getMemberships().add(membership);
            return this;
        }

        public Builder memberships(MembershipTO ... memberships) {
            ((UserCR)this.getInstance()).getMemberships().addAll(List.of(memberships));
            return this;
        }

        public Builder memberships(Collection<MembershipTO> memberships) {
            ((UserCR)this.getInstance()).getMemberships().addAll(memberships);
            return this;
        }

        public Builder role(String role) {
            ((UserCR)this.getInstance()).getRoles().add(role);
            return this;
        }

        public Builder roles(String ... roles) {
            ((UserCR)this.getInstance()).getRoles().addAll(List.of(roles));
            return this;
        }

        public Builder roles(Collection<String> roles) {
            ((UserCR)this.getInstance()).getRoles().addAll(roles);
            return this;
        }

        public Builder linkedAccount(LinkedAccountTO linkedAccount) {
            ((UserCR)this.getInstance()).getLinkedAccounts().add(linkedAccount);
            return this;
        }

        public Builder linkedAccounts(LinkedAccountTO ... linkedAccounts) {
            ((UserCR)this.getInstance()).getLinkedAccounts().addAll(List.of(linkedAccounts));
            return this;
        }

        public Builder linkedAccounts(Collection<LinkedAccountTO> linkedAccounts) {
            ((UserCR)this.getInstance()).getLinkedAccounts().addAll(linkedAccounts);
            return this;
        }
    }
}

