/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket.reactive;

import jakarta.servlet.ServletContext;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.websocket.jakarta.server.JakartaWebSocketServerContainer;
import org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.ee10.websocket.servlet.WebSocketUpgradeFilter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.springframework.boot.web.embedded.jetty.JettyReactiveWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;

public class JettyWebSocketReactiveWebServerCustomizer
implements WebServerFactoryCustomizer<JettyReactiveWebServerFactory>,
Ordered {
    public void customize(JettyReactiveWebServerFactory factory) {
        factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            ServletContextHandler servletContextHandler = this.findServletContextHandler((Handler)server);
            if (servletContextHandler != null) {
                ServletContext servletContext = servletContextHandler.getServletContext();
                if (JettyWebSocketServerContainer.getContainer((ServletContext)servletContext) == null) {
                    WebSocketServerComponents.ensureWebSocketComponents((Server)server, (ContextHandler)servletContextHandler);
                    JettyWebSocketServerContainer.ensureContainer((ServletContext)servletContext);
                }
                if (JakartaWebSocketServerContainer.getContainer((ServletContext)servletContext) == null) {
                    WebSocketServerComponents.ensureWebSocketComponents((Server)server, (ContextHandler)servletContextHandler);
                    WebSocketUpgradeFilter.ensureFilter((ServletContext)servletContext);
                    WebSocketMappings.ensureMappings((ContextHandler)servletContextHandler);
                    JakartaWebSocketServerContainer.ensureContainer((ServletContext)servletContext);
                }
            }
        }});
    }

    private ServletContextHandler findServletContextHandler(Handler handler) {
        if (handler instanceof ServletContextHandler) {
            ServletContextHandler servletContextHandler = (ServletContextHandler)handler;
            return servletContextHandler;
        }
        if (handler instanceof Handler.Wrapper) {
            Handler.Wrapper handlerWrapper = (Handler.Wrapper)handler;
            return this.findServletContextHandler(handlerWrapper.getHandler());
        }
        if (handler instanceof Handler.Collection) {
            Handler.Collection handlerCollection = (Handler.Collection)handler;
            for (Handler contained : handlerCollection.getHandlers()) {
                ServletContextHandler servletContextHandler = this.findServletContextHandler(contained);
                if (servletContextHandler == null) continue;
                return servletContextHandler;
            }
        }
        return null;
    }

    public int getOrder() {
        return 0;
    }
}

