/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.config.provider.FileConfigProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FileConfigProviderTest {
    private FileConfigProvider configProvider;
    @TempDir
    private File parent;
    private String dir;
    private String dirFile;
    private String siblingDir;
    private String siblingDirFile;

    @BeforeEach
    public void setup() throws IOException {
        this.configProvider = new TestFileConfigProvider();
        this.configProvider.configure(Collections.emptyMap());
        this.dir = Files.createDirectory(Paths.get(this.parent.toString(), "dir"), new FileAttribute[0]).toString();
        this.dirFile = Files.createFile(Paths.get(this.dir, "dirFile"), new FileAttribute[0]).toString();
        this.siblingDir = Files.createDirectory(Paths.get(this.parent.toString(), "siblingDir"), new FileAttribute[0]).toString();
        this.siblingDirFile = Files.createFile(Paths.get(this.siblingDir, "siblingDirFile"), new FileAttribute[0]).toString();
    }

    @Test
    public void testGetAllKeysAtPath() {
        ConfigData configData = this.configProvider.get("dummy");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("testKey", "testResult");
        result.put("testKey2", "testResult2");
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testGetOneKeyAtPath() {
        ConfigData configData = this.configProvider.get("dummy", Collections.singleton("testKey"));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("testKey", "testResult");
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPath() {
        ConfigData configData = this.configProvider.get("", Collections.singleton("testKey"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPathWithKey() {
        ConfigData configData = this.configProvider.get("");
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPath() {
        ConfigData configData = this.configProvider.get(null);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPathWithKey() {
        ConfigData configData = this.configProvider.get(null, Collections.singleton("testKey"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testServiceLoaderDiscovery() {
        ServiceLoader<ConfigProvider> serviceLoader = ServiceLoader.load(ConfigProvider.class);
        Assertions.assertTrue((boolean)StreamSupport.stream(serviceLoader.spliterator(), false).anyMatch(configProvider -> configProvider instanceof FileConfigProvider));
    }

    @Test
    public void testAllowedDirPath() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dir);
        this.configProvider.configure(configs);
        ConfigData configData = this.configProvider.get(this.dirFile);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("testKey", "testResult");
        result.put("testKey2", "testResult2");
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testAllowedFilePath() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dirFile);
        this.configProvider.configure(configs);
        ConfigData configData = this.configProvider.get(this.dirFile);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("testKey", "testResult");
        result.put("testKey2", "testResult2");
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testMultipleAllowedPaths() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dir + "," + this.siblingDir);
        this.configProvider.configure(configs);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("testKey", "testResult");
        result.put("testKey2", "testResult2");
        ConfigData configData = this.configProvider.get(this.dirFile);
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
        configData = this.configProvider.get(this.siblingDirFile);
        Assertions.assertEquals(result, (Object)configData.data());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNotAllowedDirPath() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dir);
        this.configProvider.configure(configs);
        ConfigData configData = this.configProvider.get(this.siblingDirFile);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNotAllowedFilePath() throws IOException {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dirFile);
        this.configProvider.configure(configs);
        Path dirFile2 = Files.createFile(Paths.get(this.dir, "dirFile2"), new FileAttribute[0]);
        ConfigData configData = this.configProvider.get(dirFile2.toString());
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNoTraversal() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dirFile);
        this.configProvider.configure(configs);
        ConfigData configData = this.configProvider.get(Paths.get(this.dirFile, "..", "..", "siblingDir", "siblingDirFile").toString());
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNonConfiguredProvider() {
        FileConfigProvider provider2 = new FileConfigProvider();
        IllegalStateException ise = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> provider2.get(Paths.get(this.dirFile, new String[0]).toString()));
        Assertions.assertEquals((Object)"The provider has not been configured yet.", (Object)ise.getMessage());
    }

    public static class TestFileConfigProvider
    extends FileConfigProvider {
        protected Reader reader(Path path) throws IOException {
            return new StringReader("testKey=testResult\ntestKey2=testResult2");
        }
    }
}

