/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.message.PushTelemetryResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.PushTelemetryResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PushTelemetryResponseTest {
    @Test
    public void testErrorCountsReturnsNoneWhenNoErrors() {
        PushTelemetryResponseData data = new PushTelemetryResponseData().setErrorCode(Errors.NONE.code());
        PushTelemetryResponse response = new PushTelemetryResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.NONE, 1), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsReturnsOneError() {
        PushTelemetryResponseData data = new PushTelemetryResponseData().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code());
        data.setErrorCode(Errors.INVALID_CONFIG.code());
        PushTelemetryResponse response = new PushTelemetryResponse(data);
        Assertions.assertEquals(Collections.singletonMap(Errors.INVALID_CONFIG, 1), (Object)response.errorCounts());
    }
}

