/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.secured;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Test;

public class ConfigurationUtilsTest
extends OAuthBearerTest {
    private static final String URL_CONFIG_NAME = "url";

    @Test
    public void testUrl() {
        this.testUrl("http://www.example.com");
    }

    @Test
    public void testUrlWithSuperfluousWhitespace() {
        this.testUrl(String.format("  %s  ", "http://www.example.com"));
    }

    @Test
    public void testUrlCaseInsensitivity() {
        this.testUrl("HTTPS://WWW.EXAMPLE.COM");
    }

    @Test
    public void testUrlFile() {
        this.testUrl("file:///tmp/foo.txt");
    }

    @Test
    public void testUrlFullPath() {
        this.testUrl("https://myidp.example.com/oauth2/default/v1/token");
    }

    @Test
    public void testUrlMissingProtocol() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testUrl("www.example.com"), "no protocol");
    }

    @Test
    public void testUrlInvalidProtocol() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testUrl("ftp://ftp.example.com"), "invalid protocol");
    }

    @Test
    public void testUrlNull() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testUrl(null), "must be non-null");
    }

    @Test
    public void testUrlEmptyString() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testUrl(""), "must not contain only whitespace");
    }

    @Test
    public void testUrlWhitespace() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testUrl("    "), "must not contain only whitespace");
    }

    private void testUrl(String value) {
        Map<String, String> configs = Collections.singletonMap(URL_CONFIG_NAME, value);
        ConfigurationUtils cu = new ConfigurationUtils(configs);
        cu.validateUrl(URL_CONFIG_NAME);
    }

    @Test
    public void testFile() throws IOException {
        File file = TestUtils.tempFile("some contents!");
        this.testFile(file.toURI().toURL().toString());
    }

    @Test
    public void testFileWithSuperfluousWhitespace() throws IOException {
        File file = TestUtils.tempFile();
        this.testFile(String.format("  %s  ", file.toURI().toURL()));
    }

    @Test
    public void testFileDoesNotExist() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testFile(new File("/tmp/not/a/real/file.txt").toURI().toURL().toString()), "that doesn't exist");
    }

    @Test
    public void testFileUnreadable() throws IOException {
        File file = TestUtils.tempFile();
        if (!file.setReadable(false)) {
            throw new IllegalStateException(String.format("Can't test file permissions as test couldn't programmatically make temp file %s un-readable", file.getAbsolutePath()));
        }
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testFile(file.toURI().toURL().toString()), "that doesn't have read permission");
    }

    @Test
    public void testFileNull() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testFile(null), "must be non-null");
    }

    @Test
    public void testFileEmptyString() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testFile(""), "must not contain only whitespace");
    }

    @Test
    public void testFileWhitespace() {
        this.assertThrowsWithMessage(ConfigException.class, () -> this.testFile("    "), "must not contain only whitespace");
    }

    protected void testFile(String value) {
        Map<String, String> configs = Collections.singletonMap(URL_CONFIG_NAME, value);
        ConfigurationUtils cu = new ConfigurationUtils(configs);
        cu.validateFile(URL_CONFIG_NAME);
    }
}

