/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.device;

import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.device.OAuth20DefaultDeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceToken;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenFactory;
import org.apereo.cas.ticket.device.OAuth20DeviceTokenUtils;

public class OAuth20DefaultDeviceTokenFactory
implements OAuth20DeviceTokenFactory {
    protected final UniqueTicketIdGenerator deviceTokenIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicyBuilder;
    protected final int userCodeLength;
    protected final ServicesManager servicesManager;

    public OAuth20DeviceToken createDeviceCode(Service service) throws Throwable {
        String codeId = this.deviceTokenIdGenerator.getNewTicketId("ODT");
        ExpirationPolicy expirationPolicyToUse = OAuth20DeviceTokenUtils.determineExpirationPolicyForService(this.servicesManager, this.expirationPolicyBuilder, service);
        return new OAuth20DefaultDeviceToken(codeId, service, expirationPolicyToUse);
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20DeviceToken.class;
    }

    @Generated
    public OAuth20DefaultDeviceTokenFactory(UniqueTicketIdGenerator deviceTokenIdGenerator, ExpirationPolicyBuilder<OAuth20DeviceToken> expirationPolicyBuilder, int userCodeLength, ServicesManager servicesManager) {
        this.deviceTokenIdGenerator = deviceTokenIdGenerator;
        this.expirationPolicyBuilder = expirationPolicyBuilder;
        this.userCodeLength = userCodeLength;
        this.servicesManager = servicesManager;
    }

    @Generated
    public ExpirationPolicyBuilder<OAuth20DeviceToken> getExpirationPolicyBuilder() {
        return this.expirationPolicyBuilder;
    }
}

