/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.idtoken;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import lombok.Generated;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.pac4j.core.profile.UserProfile;

@JsonDeserialize(builder=IdTokenGenerationContextBuilderImpl.class)
public class IdTokenGenerationContext {
    @Nonnull
    private final OAuth20AccessToken accessToken;
    @Nullable
    private final OAuth20RefreshToken refreshToken;
    @Nullable
    private final UserProfile userProfile;
    @Nonnull
    private final OAuth20ResponseTypes responseType;
    @Nonnull
    private final OAuth20GrantTypes grantType;
    @Nonnull
    private final OAuthRegisteredService registeredService;

    @Generated
    private static OAuth20ResponseTypes $default$responseType() {
        return OAuth20ResponseTypes.NONE;
    }

    @Generated
    private static OAuth20GrantTypes $default$grantType() {
        return OAuth20GrantTypes.NONE;
    }

    @Generated
    protected IdTokenGenerationContext(IdTokenGenerationContextBuilder<?, ?> b) {
        this.accessToken = b.accessToken;
        if (this.accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        this.refreshToken = b.refreshToken;
        this.userProfile = b.userProfile;
        this.responseType = b.responseType$set ? b.responseType$value : IdTokenGenerationContext.$default$responseType();
        if (this.responseType == null) {
            throw new NullPointerException("responseType is marked non-null but is null");
        }
        this.grantType = b.grantType$set ? b.grantType$value : IdTokenGenerationContext.$default$grantType();
        if (this.grantType == null) {
            throw new NullPointerException("grantType is marked non-null but is null");
        }
        this.registeredService = b.registeredService;
        if (this.registeredService == null) {
            throw new NullPointerException("registeredService is marked non-null but is null");
        }
    }

    @Generated
    public static IdTokenGenerationContextBuilder<?, ?> builder() {
        return new IdTokenGenerationContextBuilderImpl();
    }

    @Generated
    public String toString() {
        return "IdTokenGenerationContext(accessToken=" + String.valueOf(this.accessToken) + ", refreshToken=" + String.valueOf(this.refreshToken) + ", userProfile=" + String.valueOf(this.userProfile) + ", responseType=" + String.valueOf(this.responseType) + ", grantType=" + String.valueOf(this.grantType) + ", registeredService=" + String.valueOf(this.registeredService) + ")";
    }

    @Nonnull
    @Generated
    public OAuth20AccessToken getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    @Generated
    public OAuth20RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    @Nullable
    @Generated
    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    @Nonnull
    @Generated
    public OAuth20ResponseTypes getResponseType() {
        return this.responseType;
    }

    @Nonnull
    @Generated
    public OAuth20GrantTypes getGrantType() {
        return this.grantType;
    }

    @Nonnull
    @Generated
    public OAuthRegisteredService getRegisteredService() {
        return this.registeredService;
    }

    @Generated
    public IdTokenGenerationContext withAccessToken(@Nonnull OAuth20AccessToken accessToken) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        return this.accessToken == accessToken ? this : new IdTokenGenerationContext(accessToken, this.refreshToken, this.userProfile, this.responseType, this.grantType, this.registeredService);
    }

    @Generated
    public IdTokenGenerationContext withRefreshToken(@Nullable OAuth20RefreshToken refreshToken) {
        return this.refreshToken == refreshToken ? this : new IdTokenGenerationContext(this.accessToken, refreshToken, this.userProfile, this.responseType, this.grantType, this.registeredService);
    }

    @Generated
    public IdTokenGenerationContext withUserProfile(@Nullable UserProfile userProfile) {
        return this.userProfile == userProfile ? this : new IdTokenGenerationContext(this.accessToken, this.refreshToken, userProfile, this.responseType, this.grantType, this.registeredService);
    }

    @Generated
    public IdTokenGenerationContext withResponseType(@Nonnull OAuth20ResponseTypes responseType) {
        if (responseType == null) {
            throw new NullPointerException("responseType is marked non-null but is null");
        }
        return this.responseType == responseType ? this : new IdTokenGenerationContext(this.accessToken, this.refreshToken, this.userProfile, responseType, this.grantType, this.registeredService);
    }

    @Generated
    public IdTokenGenerationContext withGrantType(@Nonnull OAuth20GrantTypes grantType) {
        if (grantType == null) {
            throw new NullPointerException("grantType is marked non-null but is null");
        }
        return this.grantType == grantType ? this : new IdTokenGenerationContext(this.accessToken, this.refreshToken, this.userProfile, this.responseType, grantType, this.registeredService);
    }

    @Generated
    public IdTokenGenerationContext withRegisteredService(@Nonnull OAuthRegisteredService registeredService) {
        if (registeredService == null) {
            throw new NullPointerException("registeredService is marked non-null but is null");
        }
        return this.registeredService == registeredService ? this : new IdTokenGenerationContext(this.accessToken, this.refreshToken, this.userProfile, this.responseType, this.grantType, registeredService);
    }

    @Generated
    public IdTokenGenerationContext(@Nonnull OAuth20AccessToken accessToken, @Nullable OAuth20RefreshToken refreshToken, @Nullable UserProfile userProfile, @Nonnull OAuth20ResponseTypes responseType, @Nonnull OAuth20GrantTypes grantType, @Nonnull OAuthRegisteredService registeredService) {
        if (accessToken == null) {
            throw new NullPointerException("accessToken is marked non-null but is null");
        }
        if (responseType == null) {
            throw new NullPointerException("responseType is marked non-null but is null");
        }
        if (grantType == null) {
            throw new NullPointerException("grantType is marked non-null but is null");
        }
        if (registeredService == null) {
            throw new NullPointerException("registeredService is marked non-null but is null");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.userProfile = userProfile;
        this.responseType = responseType;
        this.grantType = grantType;
        this.registeredService = registeredService;
    }

    @Generated
    public static abstract class IdTokenGenerationContextBuilder<C extends IdTokenGenerationContext, B extends IdTokenGenerationContextBuilder<C, B>> {
        @Generated
        private OAuth20AccessToken accessToken;
        @Generated
        private OAuth20RefreshToken refreshToken;
        @Generated
        private UserProfile userProfile;
        @Generated
        private boolean responseType$set;
        @Generated
        private OAuth20ResponseTypes responseType$value;
        @Generated
        private boolean grantType$set;
        @Generated
        private OAuth20GrantTypes grantType$value;
        @Generated
        private OAuthRegisteredService registeredService;

        @Generated
        public B accessToken(@Nonnull OAuth20AccessToken accessToken) {
            if (accessToken == null) {
                throw new NullPointerException("accessToken is marked non-null but is null");
            }
            this.accessToken = accessToken;
            return this.self();
        }

        @Generated
        public B refreshToken(@Nullable OAuth20RefreshToken refreshToken) {
            this.refreshToken = refreshToken;
            return this.self();
        }

        @Generated
        public B userProfile(@Nullable UserProfile userProfile) {
            this.userProfile = userProfile;
            return this.self();
        }

        @Generated
        public B responseType(@Nonnull OAuth20ResponseTypes responseType) {
            if (responseType == null) {
                throw new NullPointerException("responseType is marked non-null but is null");
            }
            this.responseType$value = responseType;
            this.responseType$set = true;
            return this.self();
        }

        @Generated
        public B grantType(@Nonnull OAuth20GrantTypes grantType) {
            if (grantType == null) {
                throw new NullPointerException("grantType is marked non-null but is null");
            }
            this.grantType$value = grantType;
            this.grantType$set = true;
            return this.self();
        }

        @Generated
        public B registeredService(@Nonnull OAuthRegisteredService registeredService) {
            if (registeredService == null) {
                throw new NullPointerException("registeredService is marked non-null but is null");
            }
            this.registeredService = registeredService;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IdTokenGenerationContext.IdTokenGenerationContextBuilder(accessToken=" + String.valueOf(this.accessToken) + ", refreshToken=" + String.valueOf(this.refreshToken) + ", userProfile=" + String.valueOf(this.userProfile) + ", responseType$value=" + String.valueOf(this.responseType$value) + ", grantType$value=" + String.valueOf(this.grantType$value) + ", registeredService=" + String.valueOf(this.registeredService) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class IdTokenGenerationContextBuilderImpl
    extends IdTokenGenerationContextBuilder<IdTokenGenerationContext, IdTokenGenerationContextBuilderImpl> {
        @Generated
        private IdTokenGenerationContextBuilderImpl() {
        }

        @Override
        @Generated
        protected IdTokenGenerationContextBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public IdTokenGenerationContext build() {
            return new IdTokenGenerationContext(this);
        }
    }
}

