/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic.pessimistic_locking;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.Timeout;
import io.github.bucket4j.distributed.proxy.generic.pessimistic_locking.LockBasedTransaction;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractLockBasedProxyManager<K>
extends AbstractProxyManager<K> {
    protected AbstractLockBasedProxyManager(ClientSideConfig clientSideConfig) {
        super(AbstractLockBasedProxyManager.injectTimeClock(clientSideConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CommandResult<T> execute(K key, Request<T> request) {
        Timeout timeout = Timeout.of(this.getClientSideConfig());
        LockBasedTransaction transaction = timeout.call(requestTimeout -> this.allocateTransaction(key, (Optional<Long>)requestTimeout));
        try {
            CommandResult<T> commandResult = this.execute(request, transaction, timeout);
            return commandResult;
        }
        finally {
            transaction.release();
        }
    }

    @Override
    public boolean isAsyncModeSupported() {
        return false;
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CompletableFuture<Void> removeAsync(Object key) {
        return null;
    }

    protected abstract LockBasedTransaction allocateTransaction(K var1, Optional<Long> var2);

    private <T> CommandResult<T> execute(Request<T> request, LockBasedTransaction transaction, Timeout timeout) {
        byte[] persistedDataOnBeginOfTransaction;
        RemoteCommand<T> command = request.getCommand();
        timeout.run(transaction::begin);
        try {
            persistedDataOnBeginOfTransaction = timeout.call(transaction::lockAndGet);
        }
        catch (Throwable t) {
            this.unlockAndRollback(transaction);
            throw BucketExceptions.from(t);
        }
        if (persistedDataOnBeginOfTransaction == null && !request.getCommand().isInitializationCommand()) {
            this.unlockAndRollback(transaction);
            return CommandResult.bucketNotFound();
        }
        try {
            MutableBucketEntry entry = new MutableBucketEntry(persistedDataOnBeginOfTransaction);
            CommandResult<T> result = command.execute(entry, super.getClientSideTime());
            if (entry.isStateModified()) {
                byte[] bytes = entry.getStateBytes(request.getBackwardCompatibilityVersion());
                if (persistedDataOnBeginOfTransaction == null) {
                    timeout.run(requestTimeout -> transaction.create(bytes, entry.get(), (Optional<Long>)requestTimeout));
                } else {
                    timeout.run(requestTimeout -> transaction.update(bytes, entry.get(), (Optional<Long>)requestTimeout));
                }
            }
            transaction.unlock();
            timeout.run(transaction::commit);
            return result;
        }
        catch (Throwable t) {
            this.unlockAndRollback(transaction);
            throw BucketExceptions.from(t);
        }
    }

    private void unlockAndRollback(LockBasedTransaction transaction) {
        try {
            transaction.unlock();
        }
        finally {
            transaction.rollback();
        }
    }

    private static ClientSideConfig injectTimeClock(ClientSideConfig clientSideConfig) {
        if (clientSideConfig.getClientSideClock().isPresent()) {
            return clientSideConfig;
        }
        return clientSideConfig.withClientClock(TimeMeter.SYSTEM_MILLISECONDS);
    }

    protected void applyTimeout(PreparedStatement statement, Optional<Long> requestTimeoutNanos) throws SQLException {
        if (requestTimeoutNanos.isPresent()) {
            int timeoutSeconds = (int)Math.max(1L, TimeUnit.NANOSECONDS.toSeconds(requestTimeoutNanos.get()));
            statement.setQueryTimeout(timeoutSeconds);
        }
    }
}

