/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.context.properties.source.MutuallyExclusiveConfigurationPropertiesException;
import org.springframework.core.env.PropertyResolver;

public class PropertiesEndpointAccessResolver
implements EndpointAccessResolver {
    private static final String DEFAULT_ACCESS_KEY = "management.endpoints.access.default";
    private static final String ENABLED_BY_DEFAULT_KEY = "management.endpoints.enabled-by-default";
    private final PropertyResolver properties;
    private final Access endpointsDefaultAccess;
    private final Access maxPermittedAccess;
    private final Map<EndpointId, Access> accessCache = new ConcurrentHashMap<EndpointId, Access>();

    public PropertiesEndpointAccessResolver(PropertyResolver properties) {
        this.properties = properties;
        this.endpointsDefaultAccess = PropertiesEndpointAccessResolver.determineDefaultAccess(properties);
        this.maxPermittedAccess = (Access)properties.getProperty("management.endpoints.access.max-permitted", Access.class, (Object)Access.UNRESTRICTED);
    }

    private static Access determineDefaultAccess(PropertyResolver properties) {
        Access defaultAccess = (Access)properties.getProperty(DEFAULT_ACCESS_KEY, Access.class);
        Boolean endpointsEnabledByDefault = (Boolean)properties.getProperty(ENABLED_BY_DEFAULT_KEY, Boolean.class);
        MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleNonNullValuesIn(entries -> {
            entries.put(DEFAULT_ACCESS_KEY, defaultAccess);
            entries.put(ENABLED_BY_DEFAULT_KEY, endpointsEnabledByDefault);
        });
        if (defaultAccess != null) {
            return defaultAccess;
        }
        if (endpointsEnabledByDefault != null) {
            return endpointsEnabledByDefault != false ? Access.UNRESTRICTED : Access.NONE;
        }
        return null;
    }

    public Access accessFor(EndpointId endpointId, Access defaultAccess) {
        return this.accessCache.computeIfAbsent(endpointId, key -> this.resolveAccess(endpointId.toLowerCaseString(), defaultAccess).cap(this.maxPermittedAccess));
    }

    private Access resolveAccess(String endpointId, Access defaultAccess) {
        String accessKey = "management.endpoint.%s.access".formatted(endpointId);
        String enabledKey = "management.endpoint.%s.enabled".formatted(endpointId);
        Access access = (Access)this.properties.getProperty(accessKey, Access.class);
        Boolean enabled = (Boolean)this.properties.getProperty(enabledKey, Boolean.class);
        MutuallyExclusiveConfigurationPropertiesException.throwIfMultipleNonNullValuesIn(entries -> {
            entries.put(accessKey, access);
            entries.put(enabledKey, enabled);
        });
        if (access != null) {
            return access;
        }
        if (enabled != null) {
            return enabled != false ? Access.UNRESTRICTED : Access.NONE;
        }
        return this.endpointsDefaultAccess != null ? this.endpointsDefaultAccess : defaultAccess;
    }
}

