/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import com.yammer.metrics.core.MetricName;
import java.util.LinkedHashMap;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KafkaYammerMetricsTest {
    KafkaYammerMetricsTest() {
    }

    @Test
    public void testUntaggedMetric() {
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.metrics", (String)"TestMetrics", (String)"UntaggedMetric");
        Assertions.assertEquals((Object)"kafka.metrics", (Object)metricName.getGroup());
        Assertions.assertEquals((Object)"TestMetrics", (Object)metricName.getType());
        Assertions.assertEquals((Object)"UntaggedMetric", (Object)metricName.getName());
        Assertions.assertEquals((Object)"kafka.metrics:type=TestMetrics,name=UntaggedMetric", (Object)metricName.getMBeanName());
        Assertions.assertNull((Object)metricName.getScope());
    }

    @Test
    public void testTaggedMetricName() {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("foo", "bar");
        tags.put("bar", "baz");
        tags.put("baz", "raz.taz");
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.metrics", (String)"TestMetrics", (String)"TaggedMetric", tags);
        Assertions.assertEquals((Object)"kafka.metrics", (Object)metricName.getGroup());
        Assertions.assertEquals((Object)"TestMetrics", (Object)metricName.getType());
        Assertions.assertEquals((Object)"TaggedMetric", (Object)metricName.getName());
        Assertions.assertEquals((Object)"kafka.metrics:type=TestMetrics,name=TaggedMetric,foo=bar,bar=baz,baz=raz.taz", (Object)metricName.getMBeanName());
        Assertions.assertEquals((Object)"bar.baz.baz.raz_taz.foo.bar", (Object)metricName.getScope());
    }

    @Test
    public void testTaggedMetricNameWithEmptyValue() {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        tags.put("foo", "bar");
        tags.put("bar", "");
        tags.put("baz", "raz.taz");
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.metrics", (String)"TestMetrics", (String)"TaggedMetric", tags);
        Assertions.assertEquals((Object)"kafka.metrics", (Object)metricName.getGroup());
        Assertions.assertEquals((Object)"TestMetrics", (Object)metricName.getType());
        Assertions.assertEquals((Object)"TaggedMetric", (Object)metricName.getName());
        Assertions.assertEquals((Object)"kafka.metrics:type=TestMetrics,name=TaggedMetric,foo=bar,baz=raz.taz", (Object)metricName.getMBeanName());
        Assertions.assertEquals((Object)"baz.raz_taz.foo.bar", (Object)metricName.getScope());
    }
}

