/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import org.flowable.common.engine.impl.variable.NoopVariableLengthVerifier;
import org.flowable.common.engine.impl.variable.VariableLengthVerifier;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.impl.types.SerializableType;

public class LongStringType
extends SerializableType {
    public static final String TYPE_NAME = "longString";
    private final int minLength;

    public LongStringType(int minLength) {
        this(minLength, NoopVariableLengthVerifier.INSTANCE);
    }

    public LongStringType(int minLength, VariableLengthVerifier lengthVerifier) {
        super(false, lengthVerifier);
        this.minLength = minLength;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value == null) {
            valueFields.setCachedValue(null);
            valueFields.setBytes(null);
            return;
        }
        String textValue = (String)value;
        this.lengthVerifier.verifyLength(textValue.length(), valueFields, (VariableType)this);
        byte[] serializedValue = this.serialize(textValue, valueFields);
        valueFields.setBytes(serializedValue);
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return false;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringValue = (String)value;
            return stringValue.length() >= this.minLength;
        }
        return false;
    }
}

