/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ldaptive.AbstractMessage;
import org.ldaptive.LdapUtils;
import org.ldaptive.Result;
import org.ldaptive.ResultCode;
import org.ldaptive.asn1.AbstractParseHandler;
import org.ldaptive.asn1.DERBuffer;
import org.ldaptive.asn1.DERParser;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.asn1.OctetStringType;

public abstract class AbstractResult
extends AbstractMessage
implements Result {
    private final List<String> referralURLs = new ArrayList<String>();
    private ResultCode resultCode;
    private String matchedDN;
    private String diagnosticMessage;

    @Override
    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    protected final void setResultCode(ResultCode code) {
        this.resultCode = code;
    }

    @Override
    public final String getMatchedDN() {
        return this.matchedDN;
    }

    protected final void setMatchedDN(String dn) {
        this.matchedDN = dn;
    }

    @Override
    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    protected final void setDiagnosticMessage(String message) {
        this.diagnosticMessage = message;
    }

    @Override
    public final String[] getReferralURLs() {
        return this.referralURLs != null ? (String[])this.referralURLs.toArray(String[]::new) : new String[]{};
    }

    protected final void addReferralURLs(String ... urls) {
        Collections.addAll(this.referralURLs, urls);
    }

    @Override
    protected final <T extends Result> void copyValues(T result) {
        super.copyValues(result);
        this.setResultCode(result.getResultCode());
        this.setMatchedDN(result.getMatchedDN());
        this.setDiagnosticMessage(result.getDiagnosticMessage());
        this.addReferralURLs(result.getReferralURLs());
    }

    public final boolean equalsResult(Result result) {
        if (result == this) {
            return true;
        }
        if (super.equalsMessage(result)) {
            return LdapUtils.areEqual((Object)this.getResultCode(), (Object)result.getResultCode()) && LdapUtils.areEqual(this.getMatchedDN(), result.getMatchedDN()) && LdapUtils.areEqual(this.getDiagnosticMessage(), result.getDiagnosticMessage()) && LdapUtils.areEqual(this.getReferralURLs(), result.getReferralURLs());
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AbstractResult && super.equals(o)) {
            AbstractResult v = (AbstractResult)o;
            return LdapUtils.areEqual((Object)this.getResultCode(), (Object)v.getResultCode()) && LdapUtils.areEqual(this.getMatchedDN(), v.getMatchedDN()) && LdapUtils.areEqual(this.getDiagnosticMessage(), v.getDiagnosticMessage()) && LdapUtils.areEqual(this.getReferralURLs(), v.getReferralURLs());
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", resultCode=" + this.resultCode + ", matchedDN=" + this.matchedDN + ", diagnosticMessage=" + this.getEncodedDiagnosticMessage() + ", referralURLs=" + this.referralURLs;
    }

    protected static abstract class AbstractBuilder<B, T extends AbstractResult>
    extends AbstractMessage.AbstractBuilder<B, T> {
        protected AbstractBuilder(T t) {
            super(t);
        }

        public B resultCode(ResultCode code) {
            ((AbstractResult)this.object).setResultCode(code);
            return this.self();
        }

        public B matchedDN(String dn) {
            ((AbstractResult)this.object).setMatchedDN(dn);
            return this.self();
        }

        public B diagnosticMessage(String message) {
            ((AbstractResult)this.object).setDiagnosticMessage(message);
            return this.self();
        }

        public B referralURLs(String ... url) {
            ((AbstractResult)this.object).addReferralURLs(url);
            return this.self();
        }

        public B copy(Result r) {
            ((AbstractResult)this.object).copyValues(r);
            return this.self();
        }
    }

    protected static class ReferralHandler
    extends AbstractParseHandler<AbstractResult> {
        public ReferralHandler(AbstractResult response) {
            super(response);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((AbstractResult)this.getObject()).addReferralURLs(OctetStringType.decode(encoded));
        }
    }

    protected static class DiagnosticMessageHandler
    extends AbstractParseHandler<AbstractResult> {
        public DiagnosticMessageHandler(AbstractResult response) {
            super(response);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((AbstractResult)this.getObject()).setDiagnosticMessage(OctetStringType.decode(encoded));
        }
    }

    protected static class MatchedDNHandler
    extends AbstractParseHandler<AbstractResult> {
        public MatchedDNHandler(AbstractResult response) {
            super(response);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((AbstractResult)this.getObject()).setMatchedDN(OctetStringType.decode(encoded));
        }
    }

    protected static class ResultCodeHandler
    extends AbstractParseHandler<AbstractResult> {
        public ResultCodeHandler(AbstractResult response) {
            super(response);
        }

        @Override
        public void handle(DERParser parser, DERBuffer encoded) {
            ((AbstractResult)this.getObject()).setResultCode(ResultCode.valueOf(IntegerType.decodeUnsignedPrimitive(encoded)));
        }
    }
}

