/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.AbstractRequestMessage;
import org.ldaptive.BindRequest;
import org.ldaptive.Credential;
import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.ApplicationDERTag;
import org.ldaptive.asn1.ConstructedDEREncoder;
import org.ldaptive.asn1.ContextType;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.IntegerType;
import org.ldaptive.asn1.OctetStringType;

public final class SimpleBindRequest
extends AbstractRequestMessage
implements BindRequest {
    private String ldapDN;
    private byte[] password;

    private SimpleBindRequest() {
    }

    public SimpleBindRequest(String name, String pass) {
        this.setLdapDN(name);
        this.setPassword(pass);
    }

    public SimpleBindRequest(String name, Credential cred) {
        this.setLdapDN(name);
        this.setPassword(cred.getBytes());
    }

    private void setLdapDN(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("bind request name cannot be null or empty");
        }
        this.ldapDN = name;
    }

    private void setPassword(String pass) {
        if (pass == null || pass.isEmpty()) {
            throw new IllegalArgumentException("bind request password cannot be null or empty");
        }
        this.setPassword(LdapUtils.utf8Encode(pass, false));
    }

    private void setPassword(byte[] pass) {
        if (pass == null || pass.length == 0) {
            throw new IllegalArgumentException("bind request password cannot be null or empty");
        }
        this.password = pass;
    }

    @Override
    protected DEREncoder[] getRequestEncoders(int id) {
        if (this.ldapDN == null || this.ldapDN.isEmpty()) {
            throw new IllegalStateException("bind request DN cannot be null or empty");
        }
        if (this.password == null || this.password.length == 0) {
            throw new IllegalStateException("bind request password cannot be null or empty");
        }
        return new DEREncoder[]{new IntegerType(id), new ConstructedDEREncoder(new ApplicationDERTag(0, true), new IntegerType(3), new OctetStringType(this.ldapDN), new ContextType(0, this.password))};
    }

    @Override
    public String toString() {
        return super.toString() + ", dn=" + this.ldapDN;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractRequestMessage.AbstractBuilder<Builder, SimpleBindRequest> {
        private Builder() {
            super(new SimpleBindRequest());
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder dn(String dn) {
            ((SimpleBindRequest)this.object).setLdapDN(dn);
            return this.self();
        }

        public Builder password(String password) {
            ((SimpleBindRequest)this.object).setPassword(password);
            return this.self();
        }

        public Builder password(Credential credential) {
            ((SimpleBindRequest)this.object).setPassword(credential.getBytes());
            return this.self();
        }
    }
}

