/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.policy.UniquePrincipalAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.ticket.registry.InMemoryTicketRegistryProperties;
import org.apereo.cas.configuration.model.core.ticket.registry.TicketRegistryCoreProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.DefaultTicketCatalog;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.ServiceTicketGeneratorAuthority;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketFactoryExecutionPlanConfigurer;
import org.apereo.cas.ticket.TicketGrantingTicketFactory;
import org.apereo.cas.ticket.TransientSessionTicketFactory;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.expiration.builder.ProxyGrantingTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.expiration.builder.ProxyTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.expiration.builder.ServiceTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.expiration.builder.TicketGrantingTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.expiration.builder.TransientSessionTicketExpirationPolicyBuilder;
import org.apereo.cas.ticket.factory.DefaultProxyGrantingTicketFactory;
import org.apereo.cas.ticket.factory.DefaultProxyTicketFactory;
import org.apereo.cas.ticket.factory.DefaultServiceTicketFactory;
import org.apereo.cas.ticket.factory.DefaultTicketFactory;
import org.apereo.cas.ticket.factory.DefaultTicketGrantingTicketFactory;
import org.apereo.cas.ticket.factory.DefaultTransientSessionTicketFactory;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.apereo.cas.ticket.proxy.ProxyTicketFactory;
import org.apereo.cas.ticket.registry.DefaultTicketRegistry;
import org.apereo.cas.ticket.registry.DefaultTicketRegistrySupport;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.ticket.registry.pubsub.DefaultQueueableTicketRegistryMessageReceiver;
import org.apereo.cas.ticket.registry.pubsub.QueueableTicketRegistry;
import org.apereo.cas.ticket.registry.pubsub.queue.QueueableTicketRegistryMessagePublisher;
import org.apereo.cas.ticket.registry.pubsub.queue.QueueableTicketRegistryMessageReceiver;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.ticket.tracking.AllServicesSessionTrackingPolicy;
import org.apereo.cas.ticket.tracking.DefaultDescendantTicketsTrackingPolicy;
import org.apereo.cas.ticket.tracking.MostRecentServiceSessionTrackingPolicy;
import org.apereo.cas.ticket.tracking.TicketTrackingPolicy;
import org.apereo.cas.util.CoreTicketUtils;
import org.apereo.cas.util.ProxyGrantingTicketIdGenerator;
import org.apereo.cas.util.ProxyTicketIdGenerator;
import org.apereo.cas.util.PublisherIdentifier;
import org.apereo.cas.util.TicketGrantingTicketIdGenerator;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.cipher.ProtocolTicketCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.lock.LockRepository;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.integration.transaction.PseudoTransactionManager;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@EnableAsync(proxyTargetClass=false)
@EnableAspectJAutoProxy(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.TicketRegistry})
@Configuration(value="CasCoreTicketsConfiguration", proxyBeanMethods=false)
class CasCoreTicketsConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreTicketsConfiguration.class);

    CasCoreTicketsConfiguration() {
    }

    @Configuration(value="CasCoreTicketLockingConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketLockingConfiguration {
        CasCoreTicketLockingConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"casTicketRegistryLockRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LockRepository casTicketRegistryLockRepository(ConfigurableApplicationContext applicationContext) {
            return (LockRepository)BeanSupplier.of(LockRepository.class).when(BeanCondition.on((String)"cas.ticket.registry.core.enable-locking").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(LockRepository::asDefault).otherwise(LockRepository::noOp).get();
        }
    }

    @Configuration(value="CasCoreTicketTransactionConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @EnableTransactionManagement(proxyTargetClass=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class CasCoreTicketTransactionConfiguration {
        CasCoreTicketTransactionConfiguration() {
        }

        @ConditionalOnMissingBean(name={"ticketTransactionManager"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PlatformTransactionManager ticketTransactionManager() {
            return new PseudoTransactionManager();
        }
    }

    @Configuration(value="CasCoreTicketExpirationPolicyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketExpirationPolicyConfiguration {
        CasCoreTicketExpirationPolicyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"transientSessionTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder transientSessionTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new TransientSessionTicketExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"grantingTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder grantingTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new TicketGrantingTicketExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"proxyGrantingTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder proxyGrantingTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            TicketGrantingTicketExpirationPolicyBuilder grantingTicketExpirationPolicy = new TicketGrantingTicketExpirationPolicyBuilder(casProperties);
            return new ProxyGrantingTicketExpirationPolicyBuilder((ExpirationPolicyBuilder)grantingTicketExpirationPolicy, casProperties);
        }

        @ConditionalOnMissingBean(name={"serviceTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder serviceTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new ServiceTicketExpirationPolicyBuilder(casProperties);
        }

        @ConditionalOnMissingBean(name={"proxyTicketExpirationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ExpirationPolicyBuilder proxyTicketExpirationPolicy(CasConfigurationProperties casProperties) {
            return new ProxyTicketExpirationPolicyBuilder(casProperties);
        }
    }

    @Configuration(value="CasCoreTicketPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketPlanConfiguration {
        CasCoreTicketPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactory defaultTicketFactory(List<TicketFactoryExecutionPlanConfigurer> configurers) {
            DefaultTicketFactory parentFactory = new DefaultTicketFactory();
            configurers.forEach(configurer -> {
                TicketFactory factory = configurer.configureTicketFactory();
                LOGGER.trace("Registering ticket factory via [{}]", (Object)factory.getName());
                parentFactory.addTicketFactory(factory.getTicketType(), factory);
            });
            return parentFactory;
        }
    }

    @Configuration(value="CasCoreProxyGrantingTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreProxyGrantingTicketFactoryConfiguration {
        CasCoreProxyGrantingTicketFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultProxyGrantingTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ProxyGrantingTicketFactory defaultProxyGrantingTicketFactory(@Qualifier(value="proxyGrantingTicketExpirationPolicy") ExpirationPolicyBuilder proxyGrantingTicketExpirationPolicy, @Qualifier(value="proxyGrantingTicketUniqueIdGenerator") UniqueTicketIdGenerator proxyGrantingTicketUniqueIdGenerator, @Qualifier(value="protocolTicketCipherExecutor") CipherExecutor protocolTicketCipherExecutor, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultProxyGrantingTicketFactory(proxyGrantingTicketUniqueIdGenerator, proxyGrantingTicketExpirationPolicy, protocolTicketCipherExecutor, servicesManager);
        }
    }

    @Configuration(value="CasCoreTransientSessionTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTransientSessionTicketFactoryConfiguration {
        CasCoreTransientSessionTicketFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultTransientSessionTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TransientSessionTicketFactory defaultTransientSessionTicketFactory(@Qualifier(value="transientSessionTicketExpirationPolicy") ExpirationPolicyBuilder transientSessionTicketExpirationPolicy) {
            return new DefaultTransientSessionTicketFactory(transientSessionTicketExpirationPolicy);
        }
    }

    @Configuration(value="CasCoreProxyTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreProxyTicketFactoryConfiguration {
        CasCoreProxyTicketFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultProxyTicketFactory"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        public ProxyTicketFactory defaultProxyTicketFactory(@Qualifier(value="serviceTicketSessionTrackingPolicy") TicketTrackingPolicy serviceTicketSessionTrackingPolicy, @Qualifier(value="protocolTicketCipherExecutor") CipherExecutor protocolTicketCipherExecutor, @Qualifier(value="proxyTicketExpirationPolicy") ExpirationPolicyBuilder proxyTicketExpirationPolicy, @Qualifier(value="uniqueIdGeneratorsMap") Map<String, UniqueTicketIdGenerator> uniqueIdGeneratorsMap, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultProxyTicketFactory(proxyTicketExpirationPolicy, uniqueIdGeneratorsMap, protocolTicketCipherExecutor, serviceTicketSessionTrackingPolicy, servicesManager);
        }
    }

    @Configuration(value="CasCoreServiceTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServiceTicketFactoryConfiguration {
        CasCoreServiceTicketFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultServiceTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceTicketFactory defaultServiceTicketFactory(@Qualifier(value="serviceTicketSessionTrackingPolicy") TicketTrackingPolicy serviceTicketSessionTrackingPolicy, @Qualifier(value="protocolTicketCipherExecutor") CipherExecutor protocolTicketCipherExecutor, @Qualifier(value="serviceTicketExpirationPolicy") ExpirationPolicyBuilder serviceTicketExpirationPolicy, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="uniqueIdGeneratorsMap") Map<String, UniqueTicketIdGenerator> uniqueIdGeneratorsMap) {
            return new DefaultServiceTicketFactory(serviceTicketExpirationPolicy, uniqueIdGeneratorsMap, serviceTicketSessionTrackingPolicy, protocolTicketCipherExecutor, servicesManager);
        }

        @ConditionalOnMissingBean(name={"defaultServiceTicketGeneratorAuthority"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceTicketGeneratorAuthority defaultServiceTicketGeneratorAuthority() {
            return ServiceTicketGeneratorAuthority.allow();
        }
    }

    @Configuration(value="CasCoreTicketGrantingTicketFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketGrantingTicketFactoryConfiguration {
        CasCoreTicketGrantingTicketFactoryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultTicketGrantingTicketFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketGrantingTicketFactory defaultTicketGrantingTicketFactory(@Qualifier(value="grantingTicketExpirationPolicy") ExpirationPolicyBuilder grantingTicketExpirationPolicy, @Qualifier(value="protocolTicketCipherExecutor") CipherExecutor protocolTicketCipherExecutor, @Qualifier(value="ticketGrantingTicketUniqueIdGenerator") UniqueTicketIdGenerator ticketGrantingTicketUniqueIdGenerator, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return new DefaultTicketGrantingTicketFactory(ticketGrantingTicketUniqueIdGenerator, grantingTicketExpirationPolicy, protocolTicketCipherExecutor, servicesManager);
        }
    }

    @Configuration(value="CasCoreTicketGrantingTicketExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketGrantingTicketExecutionPlanConfiguration {
        CasCoreTicketGrantingTicketExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultTicketGrantingTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultTicketGrantingTicketFactoryConfigurer(@Qualifier(value="defaultTicketGrantingTicketFactory") TicketGrantingTicketFactory defaultTicketGrantingTicketFactory) {
            return () -> defaultTicketGrantingTicketFactory;
        }
    }

    @Configuration(value="CasCoreTransientSessionTicketExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTransientSessionTicketExecutionPlanConfiguration {
        CasCoreTransientSessionTicketExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultTransientSessionTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultTransientSessionTicketFactoryConfigurer(@Qualifier(value="defaultTransientSessionTicketFactory") TransientSessionTicketFactory defaultTransientSessionTicketFactory) {
            return () -> defaultTransientSessionTicketFactory;
        }
    }

    @Configuration(value="CasCoreServiceTicketExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServiceTicketExecutionPlanConfiguration {
        CasCoreServiceTicketExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultServiceTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultServiceTicketFactoryConfigurer(@Qualifier(value="defaultServiceTicketFactory") ServiceTicketFactory defaultServiceTicketFactory) {
            return () -> defaultServiceTicketFactory;
        }
    }

    @Configuration(value="CasCoreProxyTicketExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreProxyTicketExecutionPlanConfiguration {
        CasCoreProxyTicketExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultProxyTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultProxyTicketFactoryConfigurer(@Qualifier(value="defaultProxyTicketFactory") ProxyTicketFactory defaultProxyTicketFactory) {
            return () -> defaultProxyTicketFactory;
        }
    }

    @Configuration(value="CasCoreProxyGrantingTicketExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreProxyGrantingTicketExecutionPlanConfiguration {
        CasCoreProxyGrantingTicketExecutionPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"defaultProxyGrantingTicketFactoryConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketFactoryExecutionPlanConfigurer defaultProxyGrantingTicketFactoryConfigurer(@Qualifier(value="defaultProxyGrantingTicketFactory") ProxyGrantingTicketFactory defaultProxyGrantingTicketFactory) {
            return () -> defaultProxyGrantingTicketFactory;
        }
    }

    @Configuration(value="CasCoreTicketIdGeneratorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketIdGeneratorConfiguration {
        CasCoreTicketIdGeneratorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"proxyGrantingTicketUniqueIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator proxyGrantingTicketUniqueIdGenerator(CasConfigurationProperties casProperties) {
            return new ProxyGrantingTicketIdGenerator(casProperties.getTicket().getTgt().getCore().getMaxLength(), casProperties.getHost().getName());
        }

        @ConditionalOnMissingBean(name={"ticketGrantingTicketUniqueIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator ticketGrantingTicketUniqueIdGenerator(CasConfigurationProperties casProperties) {
            return new TicketGrantingTicketIdGenerator(casProperties.getTicket().getTgt().getCore().getMaxLength(), casProperties.getHost().getName());
        }

        @ConditionalOnMissingBean(name={"proxy20TicketUniqueIdGenerator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public UniqueTicketIdGenerator proxy20TicketUniqueIdGenerator(CasConfigurationProperties casProperties) {
            return new ProxyTicketIdGenerator(casProperties.getTicket().getPgt().getMaxLength(), casProperties.getHost().getName());
        }
    }

    @Configuration(value="CasCoreTicketRegistryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketRegistryConfiguration {
        CasCoreTicketRegistryConfiguration() {
        }

        @ConditionalOnMissingBean(name={"ticketRegistry"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketRegistry ticketRegistry(@Qualifier(value="messageQueueTicketRegistryPublisher") QueueableTicketRegistryMessagePublisher messageQueueTicketRegistryPublisher, @Qualifier(value="defaultTicketRegistryCipherExecutor") CipherExecutor defaultTicketRegistryCipherExecutor, @Qualifier(value="messageQueueTicketRegistryIdentifier") PublisherIdentifier messageQueueTicketRegistryIdentifier, @Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog, ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketSerializationManager") TicketSerializationManager ticketSerializationManager, CasConfigurationProperties casProperties) {
            LOGGER.info("Runtime memory is used as the persistence storage for retrieving and managing tickets. Tickets that are issued during runtime will be LOST when the web server is restarted. This MAY impact SSO functionality.");
            InMemoryTicketRegistryProperties mem = casProperties.getTicket().getRegistry().getInMemory();
            ConcurrentHashMap storageMap = new ConcurrentHashMap(mem.getInitialCapacity(), mem.getLoadFactor(), mem.getConcurrency());
            return new DefaultTicketRegistry(defaultTicketRegistryCipherExecutor, ticketSerializationManager, ticketCatalog, applicationContext, storageMap, messageQueueTicketRegistryPublisher, messageQueueTicketRegistryIdentifier);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultTicketRegistryCipherExecutor"})
        public CipherExecutor defaultTicketRegistryCipherExecutor(CasConfigurationProperties casProperties) {
            InMemoryTicketRegistryProperties mem = casProperties.getTicket().getRegistry().getInMemory();
            return CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)mem.getCrypto(), (String)"in-memory");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"messageQueueTicketRegistryPublisher"})
        public QueueableTicketRegistryMessagePublisher messageQueueTicketRegistryPublisher() {
            return QueueableTicketRegistryMessagePublisher.noOp();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"messageQueueTicketRegistryReceiver"})
        @Lazy(value=false)
        public QueueableTicketRegistryMessageReceiver messageQueueTicketRegistryReceiver(ConfigurableApplicationContext applicationContext, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="messageQueueTicketRegistryIdentifier") PublisherIdentifier messageQueueTicketRegistryIdentifier) {
            QueueableTicketRegistryMessageReceiver queueableTicketRegistryMessageReceiver;
            if (ticketRegistry instanceof QueueableTicketRegistry) {
                QueueableTicketRegistry queueableTicketRegistry = (QueueableTicketRegistry)ticketRegistry;
                queueableTicketRegistryMessageReceiver = new DefaultQueueableTicketRegistryMessageReceiver(queueableTicketRegistry, messageQueueTicketRegistryIdentifier, applicationContext);
            } else {
                queueableTicketRegistryMessageReceiver = QueueableTicketRegistryMessageReceiver.noOp();
            }
            return queueableTicketRegistryMessageReceiver;
        }

        @ConditionalOnMissingBean(name={"messageQueueTicketRegistryIdentifier"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PublisherIdentifier messageQueueTicketRegistryIdentifier(CasConfigurationProperties casProperties) {
            PublisherIdentifier bean = new PublisherIdentifier();
            TicketRegistryCoreProperties core = casProperties.getTicket().getRegistry().getCore();
            FunctionUtils.doIfNotBlank((CharSequence)core.getQueueIdentifier(), __ -> bean.setId(core.getQueueIdentifier()));
            return bean;
        }

        @Deprecated(since="7.1.0")
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"protocolTicketCipherExecutor"})
        public CipherExecutor protocolTicketCipherExecutor(CasConfigurationProperties casProperties) {
            EncryptionJwtSigningJwtCryptographyProperties crypto = casProperties.getTicket().getCrypto();
            if (crypto.isEnabled()) {
                return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, ProtocolTicketCipherExecutor.class);
            }
            LOGGER.trace("Protocol tickets generated by CAS are not signed/encrypted.");
            return CipherExecutor.noOp();
        }

        @ConditionalOnMissingBean(name={"ticketCatalog"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketCatalog ticketCatalog(CasConfigurationProperties casProperties, List<TicketCatalogConfigurer> configurers) {
            DefaultTicketCatalog plan = new DefaultTicketCatalog();
            AnnotationAwareOrderComparator.sortIfNecessary(configurers);
            configurers.forEach(Unchecked.consumer(cfg -> {
                LOGGER.trace("Configuring ticket metadata registration plan [{}]", (Object)cfg.getName());
                cfg.configureTicketCatalog((TicketCatalog)plan, casProperties);
            }));
            return plan;
        }
    }

    @Configuration(value="CasCoreTicketsAuthenticationPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketsAuthenticationPlanConfiguration {
        private static final BeanCondition CONDITION = BeanCondition.on((String)"cas.authn.policy.unique-principal.enabled").isTrue();

        CasCoreTicketsAuthenticationPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"uniqueAuthenticationPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationPolicy uniqueAuthenticationPolicy(@Qualifier(value="singleSignOnParticipationStrategy") ObjectProvider<SingleSignOnParticipationStrategy> singleSignOnParticipationStrategy, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties) {
            return new UniquePrincipalAuthenticationPolicy(ticketRegistry, singleSignOnParticipationStrategy, casProperties.getAuthn().getPolicy().getUniquePrincipal());
        }

        @ConditionalOnMissingBean(name={"ticketAuthenticationPolicyExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer ticketAuthenticationPolicyExecutionPlanConfigurer(@Qualifier(value="uniqueAuthenticationPolicy") AuthenticationPolicy uniqueAuthenticationPolicy, ConfigurableApplicationContext applicationContext) {
            return (AuthenticationEventExecutionPlanConfigurer)BeanSupplier.of(AuthenticationEventExecutionPlanConfigurer.class).when(CONDITION.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> plan -> plan.registerAuthenticationPolicy(uniqueAuthenticationPolicy)).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreTicketsBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreTicketsBaseConfiguration {
        CasCoreTicketsBaseConfiguration() {
        }

        @ConditionalOnMissingBean(name={"serviceTicketSessionTrackingPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketTrackingPolicy serviceTicketSessionTrackingPolicy(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, CasConfigurationProperties casProperties) {
            boolean onlyTrackMostRecentSession = casProperties.getTicket().getTgt().getCore().isOnlyTrackMostRecentSession();
            return onlyTrackMostRecentSession ? new MostRecentServiceSessionTrackingPolicy(ticketRegistry) : new AllServicesSessionTrackingPolicy(ticketRegistry);
        }

        @ConditionalOnMissingBean(name={"descendantTicketsTrackingPolicy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketTrackingPolicy descendantTicketsTrackingPolicy(CasConfigurationProperties casProperties) {
            return (TicketTrackingPolicy)FunctionUtils.doIf((boolean)casProperties.getTicket().isTrackDescendantTickets(), DefaultDescendantTicketsTrackingPolicy::new, TicketTrackingPolicy::noOp).get();
        }

        @ConditionalOnMissingBean(name={"defaultTicketRegistrySupport"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public TicketRegistrySupport defaultTicketRegistrySupport(@Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry) {
            return new DefaultTicketRegistrySupport(ticketRegistry);
        }
    }
}

