/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.ArrayList;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.api.PasswordlessTokenRepository;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.OneTimePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.impl.token.PasswordlessAuthenticationToken;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordlessTokenAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordlessTokenAuthenticationHandler.class);
    private final PasswordlessTokenRepository passwordlessTokenRepository;

    public PasswordlessTokenAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order, PasswordlessTokenRepository passwordlessTokenRepository) {
        super(name, servicesManager, principalFactory, order);
        this.passwordlessTokenRepository = passwordlessTokenRepository;
    }

    protected AuthenticationHandlerExecutionResult doAuthentication(Credential credential, Service service) throws Throwable {
        boolean passed;
        OneTimePasswordCredential otc = (OneTimePasswordCredential)credential;
        Optional<PasswordlessAuthenticationToken> token = this.passwordlessTokenRepository.findToken(otc.getId());
        if (token.isPresent() && (passed = token.map(PasswordlessAuthenticationToken::getToken).filter(StringUtils::isNotBlank).stream().allMatch(tk -> tk.equalsIgnoreCase(otc.getPassword())))) {
            Principal principal = this.principalFactory.createPrincipal(otc.getId());
            return this.createHandlerResult(credential, principal, new ArrayList());
        }
        throw new FailedLoginException("Passwordless authentication has failed");
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return OneTimePasswordCredential.class.isAssignableFrom(clazz);
    }

    public boolean supports(Credential credential) {
        if (!(credential instanceof OneTimePasswordCredential)) {
            LOGGER.debug("Credential is not one of one-time password and is not accepted by handler [{}]", (Object)this.getName());
            return false;
        }
        return true;
    }
}

