/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.ser.std;

import com.netflix.spectator.atlas.shaded.spectator-atlas.json.core.JsonGenerator;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JavaType;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.JsonMappingException;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.SerializerProvider;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.jsonFormatVisitors.JsonFormatTypes;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.ser.std.StdScalarSerializer;
import com.netflix.spectator.atlas.shaded.spectator-atlas.json.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

