/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.trusted.web.flow.fingerprint;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.trusted.web.flow.fingerprint.DeviceFingerprintExtractor;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoLocationDeviceFingerprintExtractor
implements DeviceFingerprintExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoLocationDeviceFingerprintExtractor.class);
    private final GeoLocationService geoLocationService;
    private int order = Integer.MAX_VALUE;

    @Override
    public Optional<String> extract(Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        GeoLocationRequest loc = WebUtils.getHttpServletRequestGeoLocation((HttpServletRequest)request);
        if (loc != null && loc.isValid()) {
            LOGGER.trace("Attempting to geolocate [{}]", (Object)loc);
            GeoLocationResponse geoResponse = this.geoLocationService.locate(loc);
            String address = geoResponse.build();
            if (StringUtils.isBlank((CharSequence)address)) {
                return GeoLocationDeviceFingerprintExtractor.getDefaultGeoLocation(loc);
            }
            return Optional.of(address);
        }
        LOGGER.trace("No geolocation could be determined from the request");
        return Optional.empty();
    }

    private static Optional<String> getDefaultGeoLocation(GeoLocationRequest loc) {
        return Optional.of(loc.getLatitude() + "-" + loc.getLongitude());
    }

    @Generated
    public GeoLocationService getGeoLocationService() {
        return this.geoLocationService;
    }

    @Override
    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public GeoLocationDeviceFingerprintExtractor(GeoLocationService geoLocationService) {
        this.geoLocationService = geoLocationService;
    }
}

