/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.jwks.generator;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.model.support.oidc.jwks.OidcJsonWebKeystoreCoreProperties;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyStoreUtils;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.util.RandomUtils;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public interface OidcJsonWebKeystoreGeneratorService {
    public static Resource toResource(JsonWebKeySet jsonWebKeySet) {
        String result = jsonWebKeySet.toJson(JsonWebKey.OutputControlLevel.INCLUDE_PRIVATE);
        return new ByteArrayResource(result.getBytes(StandardCharsets.UTF_8), "OIDC JWKS");
    }

    public static JsonWebKeySet toJsonWebKeyStore(Resource resource) throws Exception {
        String result = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        return new JsonWebKeySet(result);
    }

    public static JsonWebKey generateJsonWebKey(OidcProperties oidcProperties, OidcJsonWebKeyUsage usage) {
        OidcJsonWebKeystoreCoreProperties properties = oidcProperties.getJwks().getCore();
        PublicJsonWebKey jsonWebKey = OidcJsonWebKeyStoreUtils.generateJsonWebKey(properties.getJwksType(), properties.getJwksKeySize(), usage);
        jsonWebKey.setKeyId(properties.getJwksKeyId().concat("-").concat(RandomUtils.randomAlphabetic((int)8)));
        return jsonWebKey;
    }

    public static JsonWebKey generateJsonWebKey(OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates state, OidcProperties oidcProperties, OidcJsonWebKeyUsage usage) {
        JsonWebKey key = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(oidcProperties, usage);
        OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.setJsonWebKeyState(key, state);
        return key;
    }

    public static JsonWebKeySet generateJsonWebKeySet(OidcProperties oidcProperties) {
        JsonWebKey currentKeySigning = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT, oidcProperties, OidcJsonWebKeyUsage.SIGNING);
        JsonWebKey currentKeyEncryption = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.CURRENT, oidcProperties, OidcJsonWebKeyUsage.ENCRYPTION);
        JsonWebKey futureKeySigning = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.FUTURE, oidcProperties, OidcJsonWebKeyUsage.SIGNING);
        JsonWebKey futureKeyEncryption = OidcJsonWebKeystoreGeneratorService.generateJsonWebKey(OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.FUTURE, oidcProperties, OidcJsonWebKeyUsage.ENCRYPTION);
        return new JsonWebKeySet(new JsonWebKey[]{currentKeySigning, currentKeyEncryption, futureKeySigning, futureKeyEncryption});
    }

    public Resource generate() throws Throwable;

    public JsonWebKeySet store(JsonWebKeySet var1) throws Throwable;

    public Optional<Resource> find() throws Throwable;
}

