/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.wa.bootstrap.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyConf;
import org.apache.syncope.common.lib.policy.AttrReleasePolicyTO;
import org.apache.syncope.common.lib.policy.DefaultAttrReleasePolicyConf;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.to.OIDCRPClientAppTO;
import org.apache.syncope.wa.bootstrap.mapping.AttrReleaseMapper;
import org.apereo.cas.authentication.principal.DefaultPrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.RegisteredServicePrincipalAttributesRepository;
import org.apereo.cas.authentication.principal.cache.CachingPrincipalAttributesRepository;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesCoreProperties;
import org.apereo.cas.configuration.support.TriStateBoolean;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcAddressScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcEmailScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcPhoneScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcProfileScopeAttributeReleasePolicy;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ChainingAttributeReleasePolicy;
import org.apereo.cas.services.DenyAllAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy;
import org.apereo.cas.services.ReturnMappedAttributeReleasePolicy;
import org.apereo.cas.services.consent.DefaultRegisteredServiceConsentPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAttrReleaseMapper
implements AttrReleaseMapper {
    protected static final Logger LOG = LoggerFactory.getLogger(AttrReleaseMapper.class);

    protected static void warnMissingScope(String clientApp, String internal, Object external, String scope) {
        LOG.warn("OIDC client app {} defines claim mapping {}={} but does not specify the related scope {}", new Object[]{clientApp, internal, external, scope});
    }

    @Override
    public boolean supports(AttrReleasePolicyConf conf) {
        return DefaultAttrReleasePolicyConf.class.equals((Object)conf.getClass());
    }

    protected Map<String, BaseOidcScopeAttributeReleasePolicy> buildOidc(OIDCRPClientAppTO rp, DefaultAttrReleasePolicyConf conf) {
        HashMap<String, BaseOidcScopeAttributeReleasePolicy> policies = new HashMap<String, BaseOidcScopeAttributeReleasePolicy>();
        conf.getReleaseAttrs().forEach((internal, external) -> {
            if (OidcProfileScopeAttributeReleasePolicy.ALLOWED_CLAIMS.contains(external.toString())) {
                if (rp.getScopes().contains("profile")) {
                    policies.computeIfAbsent("profile", k -> new OidcProfileScopeAttributeReleasePolicy()).getClaimMappings().put(external.toString(), internal);
                } else {
                    DefaultAttrReleaseMapper.warnMissingScope(rp.getName(), internal, external, "profile");
                }
            } else if (OidcEmailScopeAttributeReleasePolicy.ALLOWED_CLAIMS.contains(external.toString())) {
                if (rp.getScopes().contains("email")) {
                    policies.computeIfAbsent("email", k -> new OidcEmailScopeAttributeReleasePolicy()).getClaimMappings().put(external.toString(), internal);
                } else {
                    DefaultAttrReleaseMapper.warnMissingScope(rp.getName(), internal, external, "email");
                }
            } else if (OidcAddressScopeAttributeReleasePolicy.ALLOWED_CLAIMS.contains(external.toString())) {
                if (rp.getScopes().contains("address")) {
                    policies.computeIfAbsent("address", k -> new OidcAddressScopeAttributeReleasePolicy()).getClaimMappings().put(external.toString(), internal);
                } else {
                    DefaultAttrReleaseMapper.warnMissingScope(rp.getName(), internal, external, "address");
                }
            } else if (OidcPhoneScopeAttributeReleasePolicy.ALLOWED_CLAIMS.contains(external.toString())) {
                if (rp.getScopes().contains("phone")) {
                    policies.computeIfAbsent("phone", k -> new OidcPhoneScopeAttributeReleasePolicy()).getClaimMappings().put(external.toString(), internal);
                } else {
                    DefaultAttrReleaseMapper.warnMissingScope(rp.getName(), internal, external, "phone");
                }
            } else {
                BaseOidcScopeAttributeReleasePolicy custom = policies.computeIfAbsent("syncope", k -> new OidcCustomScopeAttributeReleasePolicy("syncope", new ArrayList()));
                custom.getAllowedAttributes().add(external.toString());
                custom.getClaimMappings().put(external.toString(), internal);
            }
        });
        return policies;
    }

    protected void setPrincipalAttributesRepository(DefaultAttrReleasePolicyConf.PrincipalAttrRepoConf parc, AbstractRegisteredServiceAttributeReleasePolicy policy) {
        CachingPrincipalAttributesRepository par = parc.getExpiration() > 0L ? new CachingPrincipalAttributesRepository(parc.getTimeUnit().name(), parc.getExpiration()) : new DefaultPrincipalAttributesRepository();
        par.setMergingStrategy(PrincipalAttributesCoreProperties.MergingStrategyTypes.valueOf((String)parc.getMergingStrategy().name()));
        par.setIgnoreResolvedAttributes(par.isIgnoreResolvedAttributes());
        par.setAttributeRepositoryIds(new HashSet(parc.getAttrRepos()));
        policy.setPrincipalAttributesRepository((RegisteredServicePrincipalAttributesRepository)par);
    }

    protected Optional<DefaultRegisteredServiceConsentPolicy> buildConsentPolicy(AttrReleasePolicyTO policy, DefaultAttrReleasePolicyConf conf) {
        if (conf.getExcludedAttrs().isEmpty() && conf.getIncludeOnlyAttrs().isEmpty()) {
            return Optional.empty();
        }
        DefaultRegisteredServiceConsentPolicy consentPolicy = new DefaultRegisteredServiceConsentPolicy(new HashSet(conf.getExcludedAttrs()), new HashSet(conf.getIncludeOnlyAttrs()));
        consentPolicy.setOrder(policy.getOrder());
        consentPolicy.setStatus(TriStateBoolean.fromBoolean((boolean)policy.getStatus()));
        return Optional.of(consentPolicy);
    }

    @Override
    public RegisteredServiceAttributeReleasePolicy build(ClientAppTO app, AttrReleasePolicyTO policy) {
        DefaultAttrReleasePolicyConf conf = (DefaultAttrReleasePolicyConf)policy.getConf();
        Map<String, BaseOidcScopeAttributeReleasePolicy> oidc = null;
        ReturnMappedAttributeReleasePolicy returnMapped = null;
        if (!conf.getReleaseAttrs().isEmpty()) {
            if (app instanceof OIDCRPClientAppTO) {
                OIDCRPClientAppTO rp = (OIDCRPClientAppTO)app;
                oidc = this.buildOidc(rp, conf);
            } else {
                returnMapped = new ReturnMappedAttributeReleasePolicy();
                returnMapped.setAllowedAttributes(conf.getReleaseAttrs());
            }
        }
        ReturnAllowedAttributeReleasePolicy returnAllowed = null;
        if (!conf.getAllowedAttrs().isEmpty()) {
            returnAllowed = new ReturnAllowedAttributeReleasePolicy();
            returnAllowed.setAllowedAttributes(conf.getAllowedAttrs());
        }
        ChainingAttributeReleasePolicy chain = new ChainingAttributeReleasePolicy();
        DenyAllAttributeReleasePolicy single = null;
        if (oidc == null) {
            if (returnMapped == null && returnAllowed == null) {
                single = new DenyAllAttributeReleasePolicy();
            } else if (returnMapped != null && returnAllowed == null) {
                single = returnMapped;
            } else if (returnMapped == null && returnAllowed != null) {
                single = returnAllowed;
            } else {
                chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{returnMapped, returnAllowed});
            }
        } else if (oidc.size() == 1) {
            single = (AbstractRegisteredServiceAttributeReleasePolicy)oidc.values().iterator().next();
        } else {
            oidc.entrySet().stream().filter(entry -> !"syncope".equals(entry.getKey())).forEach(entry -> chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{(RegisteredServiceAttributeReleasePolicy)entry.getValue()}));
            Optional.ofNullable(oidc.get("syncope")).ifPresent(xva$0 -> chain.addPolicies(new RegisteredServiceAttributeReleasePolicy[]{xva$0}));
        }
        Optional<DefaultRegisteredServiceConsentPolicy> consentPolicy = this.buildConsentPolicy(policy, conf);
        if (!chain.getPolicies().isEmpty()) {
            Optional.ofNullable(conf.getPrincipalAttrRepoConf()).ifPresent(parc -> chain.setMergingPolicy(PrincipalAttributesCoreProperties.MergingStrategyTypes.valueOf((String)parc.getMergingStrategy().name())));
            chain.getPolicies().stream().filter(AbstractRegisteredServiceAttributeReleasePolicy.class::isInstance).map(AbstractRegisteredServiceAttributeReleasePolicy.class::cast).forEach(p -> {
                consentPolicy.ifPresent(arg_0 -> ((AbstractRegisteredServiceAttributeReleasePolicy)p).setConsentPolicy(arg_0));
                Optional.ofNullable(conf.getPrincipalIdAttr()).ifPresent(arg_0 -> ((AbstractRegisteredServiceAttributeReleasePolicy)p).setPrincipalIdAttribute(arg_0));
                Optional.ofNullable(conf.getPrincipalAttrRepoConf()).filter(parc -> !parc.getAttrRepos().isEmpty()).ifPresent(parc -> this.setPrincipalAttributesRepository((DefaultAttrReleasePolicyConf.PrincipalAttrRepoConf)parc, (AbstractRegisteredServiceAttributeReleasePolicy)p));
            });
        }
        Optional.ofNullable(single).ifPresent(p -> {
            consentPolicy.ifPresent(arg_0 -> ((AbstractRegisteredServiceAttributeReleasePolicy)p).setConsentPolicy(arg_0));
            Optional.ofNullable(conf.getPrincipalIdAttr()).ifPresent(arg_0 -> ((AbstractRegisteredServiceAttributeReleasePolicy)p).setPrincipalIdAttribute(arg_0));
            Optional.ofNullable(conf.getPrincipalAttrRepoConf()).filter(parc -> !parc.getAttrRepos().isEmpty()).ifPresent(parc -> this.setPrincipalAttributesRepository((DefaultAttrReleasePolicyConf.PrincipalAttrRepoConf)parc, (AbstractRegisteredServiceAttributeReleasePolicy)p));
        });
        return single == null ? chain : single;
    }
}

