/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3.commands;

import com.icegreen.greenmail.pop3.Pop3Connection;
import com.icegreen.greenmail.pop3.Pop3State;
import com.icegreen.greenmail.pop3.commands.Pop3Command;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import com.icegreen.greenmail.util.EncodingUtil;
import com.icegreen.greenmail.util.SaslMessage;
import com.icegreen.greenmail.util.SaslXoauth2Message;
import java.io.IOException;
import java.util.Arrays;

public class AuthCommand
extends Pop3Command {
    public static final String CONTINUATION = "+ ";

    @Override
    public boolean isValidForState(Pop3State state) {
        return !state.isAuthenticated();
    }

    @Override
    public void execute(Pop3Connection conn, Pop3State state, String cmd) {
        if (state.isAuthenticated()) {
            conn.println("-ERR Already authenticated");
            return;
        }
        String[] args = cmd.split(" ");
        if (args.length < 2) {
            conn.println("-ERR Required syntax: AUTH mechanism [initial-response] but received <" + cmd + ">");
            return;
        }
        String mechanism = args[1];
        if (Pop3SaslAuthMechanism.PLAIN.name().equalsIgnoreCase(mechanism)) {
            this.authPlain(conn, state, args);
        } else if (Pop3SaslAuthMechanism.XOAUTH2.name().equalsIgnoreCase(mechanism)) {
            this.authXoauth2(conn, state, args);
        } else {
            conn.println("-ERR Required syntax: AUTH mechanism <" + mechanism + "> not supported, expected one of " + Arrays.toString((Object[])Pop3SaslAuthMechanism.values()));
        }
    }

    private void authPlain(Pop3Connection conn, Pop3State state, String[] args) {
        SaslMessage saslMessage;
        String initialResponse = this.initialResponse(conn, args);
        if (null == initialResponse) {
            conn.println("-ERR Invalid syntax, expected initial-response : AUTH PLAIN [initial-response]");
            return;
        }
        try {
            saslMessage = SaslMessage.parse(EncodingUtil.decodeBase64(initialResponse));
        }
        catch (IllegalArgumentException ex) {
            this.log.error("Expected base64 encoding but got <{}>", (Object)initialResponse, (Object)ex);
            conn.println("-ERR Authentication failed, expected base64 encoding : " + ex.getMessage());
            return;
        }
        this.authenticateUser(conn, state, saslMessage.getAuthcid(), saslMessage.getPasswd());
    }

    private void authXoauth2(Pop3Connection conn, Pop3State state, String[] args) {
        SaslXoauth2Message xoauth2Message;
        String initialResponse = this.initialResponse(conn, args);
        if (null == initialResponse) {
            conn.println("-ERR Invalid syntax, expected initial-response : AUTH XOAUTH2 [initial-response]");
            return;
        }
        try {
            xoauth2Message = SaslXoauth2Message.parseBase64Encoded(initialResponse);
        }
        catch (IllegalArgumentException ex) {
            this.log.error("Expected XOAUTH2 format but got <{}>", (Object)initialResponse, (Object)ex);
            conn.println("-ERR Authentication failed, expected XOAUTH2 format : " + ex.getMessage());
            return;
        }
        this.authenticateUser(conn, state, xoauth2Message.getUsername(), xoauth2Message.getAccessToken());
    }

    private String initialResponse(Pop3Connection conn, String[] args) {
        if (args.length == 2 || args.length == 3 && "=".equals(args[2])) {
            conn.println(CONTINUATION);
            try {
                return conn.readLine();
            }
            catch (IOException e) {
                conn.println("-ERR Invalid syntax, expected continuation with initial-response");
                return null;
            }
        }
        if (args.length == 3) {
            return args[2];
        }
        return null;
    }

    private void authenticateUser(Pop3Connection conn, Pop3State state, String username, String credentials) {
        GreenMailUser user;
        try {
            user = state.getUser(username);
            state.setUser(user);
        }
        catch (UserException e) {
            this.log.error("Can not get user <{}>", (Object)username, (Object)e);
            conn.println("-ERR Authentication failed: " + e.getMessage());
            return;
        }
        try {
            state.authenticate(credentials);
            conn.println("+OK");
        }
        catch (UserException e) {
            this.log.error("Can not authenticate using user <{}>", (Object)user.getLogin(), (Object)e);
            conn.println("-ERR Authentication failed: " + e.getMessage());
        }
        catch (FolderException e) {
            this.log.error("Can not authenticate using user {}, internal error", (Object)user, (Object)e);
            conn.println("-ERR Authentication failed, internal error: " + e.getMessage());
        }
    }

    public static enum Pop3SaslAuthMechanism {
        PLAIN,
        XOAUTH2;


        static String list() {
            StringBuilder buf = new StringBuilder();
            for (Pop3SaslAuthMechanism mechanism : Pop3SaslAuthMechanism.values()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(mechanism.name());
            }
            return buf.toString();
        }
    }
}

