/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.OutputStream;
import java.util.HashMap;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.oauth.profile.JsonHelper;

public class CronofyService
extends OAuth20Service {
    private final DefaultApi20 api;

    public CronofyService(DefaultApi20 api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(api, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
        this.api = api;
    }

    protected OAuthRequest createAccessTokenRequest(AccessTokenRequestParams params) {
        String json;
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("client_id", this.getApiKey());
        map.put("client_secret", this.getApiSecret());
        map.put("grant_type", "authorization_code");
        map.put("code", params.getCode());
        map.put("redirect_uri", this.getCallback());
        try {
            json = JsonHelper.getMapper().writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new TechnicalException((Throwable)e);
        }
        request.setPayload(json);
        request.addHeader("Content-Type", "application/json; charset=utf-8");
        this.logRequestWithParams("access token", request);
        return request;
    }
}

