/**
 * @license
 * Copyright 2016 Google Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/**
 * MDCChipCssClasses provides the named constants for class names.
 */
export var MDCChipCssClasses;
(function (MDCChipCssClasses) {
    MDCChipCssClasses["SELECTING"] = "mdc-evolution-chip--selecting";
    MDCChipCssClasses["DESELECTING"] = "mdc-evolution-chip--deselecting";
    MDCChipCssClasses["SELECTING_WITH_PRIMARY_ICON"] = "mdc-evolution-chip--selecting-with-primary-icon";
    MDCChipCssClasses["DESELECTING_WITH_PRIMARY_ICON"] = "mdc-evolution-chip--deselecting-with-primary-icon";
    MDCChipCssClasses["DISABLED"] = "mdc-evolution-chip--disabled";
    MDCChipCssClasses["ENTER"] = "mdc-evolution-chip--enter";
    MDCChipCssClasses["EXIT"] = "mdc-evolution-chip--exit";
    MDCChipCssClasses["SELECTED"] = "mdc-evolution-chip--selected";
    MDCChipCssClasses["HIDDEN"] = "mdc-evolution-chip--hidden";
    MDCChipCssClasses["WITH_PRIMARY_ICON"] = "mdc-evolution-chip--with-primary-icon";
})(MDCChipCssClasses || (MDCChipCssClasses = {}));
/**
 * MDCChipEvents provides the named constants for emitted events.
 */
export var MDCChipEvents;
(function (MDCChipEvents) {
    MDCChipEvents["INTERACTION"] = "MDCChip:interaction";
    MDCChipEvents["NAVIGATION"] = "MDCChip:navigation";
    MDCChipEvents["ANIMATION"] = "MDCChip:animation";
})(MDCChipEvents || (MDCChipEvents = {}));
/**
 * MDCChipAttributes provides the named constants for strings used by the
 * foundation.
 */
export var MDCChipAttributes;
(function (MDCChipAttributes) {
    MDCChipAttributes["DATA_REMOVED_ANNOUNCEMENT"] = "data-mdc-removed-announcement";
    MDCChipAttributes["DATA_ADDED_ANNOUNCEMENT"] = "data-mdc-added-announcement";
})(MDCChipAttributes || (MDCChipAttributes = {}));
/**
 * MDCChipAnimation provides the names of runnable animations.
 */
export var MDCChipAnimation;
(function (MDCChipAnimation) {
    MDCChipAnimation["ENTER"] = "mdc-evolution-chip-enter";
    MDCChipAnimation["EXIT"] = "mdc-evolution-chip-exit";
})(MDCChipAnimation || (MDCChipAnimation = {}));
//# sourceMappingURL=constants.js.map