/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.Logging$class;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.BlacklistTracker$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class BlacklistTracker$
implements Logging {
    public static final BlacklistTracker$ MODULE$;
    private final String org$apache$spark$scheduler$BlacklistTracker$$DEFAULT_TIMEOUT;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BlacklistTracker$();
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging$class.initializeLogIfNecessary(this, isInterpreter);
    }

    public String org$apache$spark$scheduler$BlacklistTracker$$DEFAULT_TIMEOUT() {
        return this.org$apache$spark$scheduler$BlacklistTracker$$DEFAULT_TIMEOUT;
    }

    public boolean isBlacklistEnabled(SparkConf conf) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    boolean enabled;
                    option = (Option)conf.get(package$.MODULE$.BLACKLIST_ENABLED());
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    bl = enabled = BoxesRunTime.unboxToBoolean((Object)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                String legacyKey = package$.MODULE$.BLACKLIST_LEGACY_TIMEOUT_CONF().key();
                bl = ((Option)conf.get(package$.MODULE$.BLACKLIST_LEGACY_TIMEOUT_CONF())).exists((Function1)new Serializable(legacyKey){
                    public static final long serialVersionUID = 0L;
                    public final String legacyKey$1;

                    public final boolean apply(long legacyTimeout) {
                        return this.apply$mcZJ$sp(legacyTimeout);
                    }

                    public boolean apply$mcZJ$sp(long legacyTimeout) {
                        boolean bl;
                        if (legacyTimeout == 0L) {
                            BlacklistTracker$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.isBlacklistEnabled.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Turning off blacklisting due to legacy configuration: ", " == 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.legacyKey$1}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            bl = false;
                        } else {
                            BlacklistTracker$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.isBlacklistEnabled.1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Turning on blacklisting due to legacy configuration: ", " > 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.legacyKey$1}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            bl = true;
                        }
                        return bl;
                    }
                    {
                        this.legacyKey$1 = legacyKey$1;
                    }
                });
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public long getBlacklistTimeout(SparkConf conf) {
        return BoxesRunTime.unboxToLong((Object)((Option)conf.get(package$.MODULE$.BLACKLIST_TIMEOUT_CONF())).getOrElse((Function0)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return BoxesRunTime.unboxToLong((Object)((Option)this.conf$1.get(package$.MODULE$.BLACKLIST_LEGACY_TIMEOUT_CONF())).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return Utils$.MODULE$.timeStringAsMs(BlacklistTracker$.MODULE$.org$apache$spark$scheduler$BlacklistTracker$$DEFAULT_TIMEOUT());
                    }
                }));
            }
            {
                this.conf$1 = conf$1;
            }
        }));
    }

    public void validateBlacklistConfs(SparkConf conf) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{package$.MODULE$.MAX_TASK_ATTEMPTS_PER_EXECUTOR(), package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE(), package$.MODULE$.MAX_FAILURES_PER_EXEC_STAGE(), package$.MODULE$.MAX_FAILED_EXEC_PER_NODE_STAGE()}))).foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final SparkConf conf$2;

            public final void apply(ConfigEntry<Object> config) {
                int v = BoxesRunTime.unboxToInt((Object)this.conf$2.get(config));
                if (v <= 0) {
                    BlacklistTracker$.MODULE$.org$apache$spark$scheduler$BlacklistTracker$$mustBePos$1(config.key(), ((Object)BoxesRunTime.boxToInteger((int)v)).toString());
                }
            }
            {
                this.conf$2 = conf$2;
            }
        });
        long timeout = this.getBlacklistTimeout(conf);
        if (timeout <= 0L) {
            Option option = (Option)conf.get(package$.MODULE$.BLACKLIST_TIMEOUT_CONF());
            if (option instanceof Some) {
                this.org$apache$spark$scheduler$BlacklistTracker$$mustBePos$1(package$.MODULE$.BLACKLIST_TIMEOUT_CONF().key(), ((Object)BoxesRunTime.boxToLong((long)timeout)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                this.org$apache$spark$scheduler$BlacklistTracker$$mustBePos$1(package$.MODULE$.BLACKLIST_LEGACY_TIMEOUT_CONF().key(), ((Object)BoxesRunTime.boxToLong((long)timeout)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
        }
        int maxTaskFailures = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_FAILURES()));
        int maxNodeAttempts = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE()));
        if (maxNodeAttempts >= maxTaskFailures) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"( = ", ") was >= ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxNodeAttempts), package$.MODULE$.MAX_TASK_FAILURES().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"( = ", " ).  Though blacklisting is enabled, with this configuration, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxTaskFailures)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Spark will not be robust to one bad node.  Decrease "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", increase ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key(), package$.MODULE$.MAX_TASK_FAILURES().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"or disable blacklisting with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BLACKLIST_ENABLED().key()}))).toString());
        }
    }

    public final void org$apache$spark$scheduler$BlacklistTracker$$mustBePos$1(String k, String v) {
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " was ", ", but must be > 0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v})));
    }

    private BlacklistTracker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.org$apache$spark$scheduler$BlacklistTracker$$DEFAULT_TIMEOUT = "1h";
    }
}

