---
permalink: /docs/papers-talks
---

# Papers, Talks, and Related Articles

This document tracks papers, talks, and related articles around Teaclave and its
community.

## Papers

- [RusTEE: Developing Memory-Safe ARM TrustZone Applications](https://csis.gmu.edu/ksun/publications/ACSAC20_RusTEE_2020.pdf).
  Shengye Wan, Mingshen Sun, Kun Sun, Ning Zhang, and Xu He.
  In Proceedings of the 36th Annual Computer Security Applications Conference.
  ACSAC '20, Dec 2020.
- [Building and Maintaining a Third-Party Library Supply Chain for Productive and Secure SGX Enclave Development](https://arxiv.org/abs/2005.04367).
  Pei Wang, Yu Ding, Mingshen Sun, Huibo Wang, Tongxin Li, Rundong Zhou, Zhaofeng Chen, and Yiming Jing.
  In Proceedings of the 42nd International Conference on Software Engineering, the Software Engineering In Practice Track.
  ICSE-SEIP '20, May 2020.
- [Towards Memory Safe Enclave Programming with Rust-SGX](https://dingelish.com/ccs19.pdf).
  Huibo Wang, Pei Wang, Yu Ding, Mingshen Sun, Yiming Jing, Ran Duan, Long Li, Yulong Zhang, Tao Wei, and Zhiqiang Lin.
  In Proceedings of the 2019 ACM SIGSAC Conference on Computer and Communications Security.
  CCS'19, November 2019.

## Talks

- [Teaclave: A Universal Secure Computing Platform](https://mssun.me/assets/teaclave-2nd-sgx-community-workshop.pdf).
  Mingshen Sun.
  The 2nd SGX Community Workshop, July 2020.
- [Rust TrustZone SDK: Enabling Safe, Functional, and Ergonomic Development of Trustlets](https://static.sched.com/hosted_files/linaroconnectsandiego/7e/SAN19-513.pdf).
  Mingshen Sun.
  Linaro Connect San Diego 2019, San Diego, Sep 2019
- [MesaTEE SGX: Redefining AI and Big Data Analysis with Intel SGX](https://query.prod.cms.rt.microsoft.com/cms/api/am/binary/RE37dMs).
  Yu Ding.
  BlueHat Shanghai '19, May 2019.
- [Bringing Intel SGX to the Rust Ecosystem](https://paris.rustfest.eu/sessions/mesalock-sgx).
  Yu Ding.
  RustFest Paris '18, 2018.
- [Towards Memory Safety in Intel SGX Enclave](https://www.infoq.com/presentations/intel-sgx-enclave/).
  Yu Ding.
  QCon SF, 2017.
