/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.catalina.filters.CsrfPreventionFilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CsrfPreventionFilter
extends CsrfPreventionFilterBase {
    private static final String DEFAULT_NO_NONCE_URL_PATTERNS = "*.css, *.js, *.gif, *.png, *.jpg, *.svg, *.ico, *.jpeg, *.mjs";
    private ServletContext context;
    private final Log log = LogFactory.getLog(CsrfPreventionFilter.class);
    private final Set<String> entryPoints = new HashSet<String>();
    private int nonceCacheSize = 5;
    private String nonceRequestParameterName = "org.apache.catalina.filters.CSRF_NONCE";
    private boolean enforce = true;
    private String noNoncePatterns = "*.css, *.js, *.gif, *.png, *.jpg, *.svg, *.ico, *.jpeg, *.mjs";
    private Collection<Predicate<String>> noNoncePredicates;

    public void setEntryPoints(String entryPoints) {
        String[] values;
        for (String value : values = entryPoints.split(",")) {
            this.entryPoints.add(value.trim());
        }
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        this.nonceCacheSize = nonceCacheSize;
    }

    public void setNonceRequestParameterName(String parameterName) {
        this.nonceRequestParameterName = parameterName;
    }

    public void setEnforce(boolean enforce) {
        this.enforce = enforce;
    }

    public boolean isEnforce() {
        return this.enforce;
    }

    public void setNoNonceURLPatterns(String patterns) {
        this.noNoncePatterns = patterns;
        if (null != this.context) {
            this.noNoncePredicates = CsrfPreventionFilter.createNoNoncePredicates(this.context, this.noNoncePatterns);
        }
    }

    protected static Collection<Predicate<String>> createNoNoncePredicates(ServletContext context, String patterns) {
        if (null == patterns || patterns.trim().isEmpty()) {
            return null;
        }
        if (patterns.startsWith("/") && patterns.endsWith("/")) {
            return Collections.singleton(new PatternPredicate(patterns.substring(1, patterns.length() - 1)));
        }
        String[] values = patterns.split(",");
        ArrayList<Predicate<String>> matchers = new ArrayList<Predicate<String>>(values.length);
        for (String value : values) {
            Predicate<String> p = CsrfPreventionFilter.createNoNoncePredicate(context, value.trim());
            if (null == p) continue;
            matchers.add(p);
        }
        matchers.trimToSize();
        return matchers;
    }

    protected static Predicate<String> createNoNoncePredicate(ServletContext context, String pattern) {
        if (null == pattern || pattern.trim().isEmpty()) {
            return null;
        }
        if (pattern.startsWith("mime:")) {
            return new MimePredicate(context, CsrfPreventionFilter.createNoNoncePredicate(context, pattern.substring(5)));
        }
        if (pattern.startsWith("*")) {
            return new SuffixPredicate(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return new PrefixPredicate(pattern.substring(0, pattern.length() - 1));
        }
        if (pattern.startsWith("/") && pattern.endsWith("/")) {
            return new PatternPredicate(pattern.substring(1, pattern.length() - 1));
        }
        throw new IllegalArgumentException(sm.getString("csrfPrevention.unsupportedPattern", pattern));
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.context = filterConfig.getServletContext();
        this.noNoncePredicates = CsrfPreventionFilter.createNoNoncePredicates(this.context, this.noNoncePatterns);
        filterConfig.getServletContext().setAttribute("org.apache.catalina.filters.CSRF_NONCE_PARAM_NAME", this.nonceRequestParameterName);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CsrfResponseWrapper wResponse = null;
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            if (response instanceof HttpServletResponse) {
                HttpServletResponse res = (HttpServletResponse)response;
                HttpSession session = req.getSession(false);
                String requestedPath = this.getRequestedPath(req);
                boolean skipNonceCheck = this.skipNonceCheck(req);
                NonceCache<String> nonceCache = null;
                if (!skipNonceCheck) {
                    String previousNonce = req.getParameter(this.nonceRequestParameterName);
                    if (previousNonce == null) {
                        if (this.enforce(req, requestedPath)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(sm.getString("csrfPrevention.rejectNoNonce", this.getRequestedPath(req), null == session ? "(null)" : session.getId()));
                            }
                            res.sendError(this.getDenyStatus());
                            return;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Would have rejected request for " + this.getRequestedPath(req) + ", session " + (null == session ? "(null)" : session.getId()) + " with no CSRF nonce found in request");
                        }
                    } else {
                        nonceCache = this.getNonceCache(req, session);
                        if (nonceCache == null) {
                            if (this.enforce(req, requestedPath)) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug(sm.getString("csrfPrevention.rejectNoCache", this.getRequestedPath(req), null == session ? "(null)" : session.getId()));
                                }
                                res.sendError(this.getDenyStatus());
                                return;
                            }
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Would have rejecting request for " + this.getRequestedPath(req) + ", session " + (null == session ? "(null)" : session.getId()) + " due to empty / missing nonce cache");
                            }
                        } else if (!nonceCache.contains(previousNonce)) {
                            if (this.enforce(req, requestedPath)) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug(sm.getString("csrfPrevention.rejectInvalidNonce", this.getRequestedPath(req), null == session ? "(null)" : session.getId(), previousNonce));
                                }
                                res.sendError(this.getDenyStatus());
                                return;
                            }
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Would have rejecting request for " + this.getRequestedPath(req) + ", session " + (null == session ? "(null)" : session.getId()) + " due to invalid nonce " + previousNonce);
                            }
                        } else if (this.log.isTraceEnabled()) {
                            this.log.trace("Allowing request to " + this.getRequestedPath(req) + " with valid CSRF nonce " + previousNonce);
                        }
                    }
                }
                if (!this.skipNonceGeneration(req)) {
                    if (skipNonceCheck) {
                        nonceCache = this.getNonceCache(req, session);
                    }
                    if (nonceCache == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(sm.getString("csrfPrevention.createCache", this.nonceCacheSize, null == session ? "(null)" : session.getId()));
                        }
                        if (session == null) {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace("Creating new session to store CSRF nonce cache");
                            }
                            session = req.getSession(true);
                        }
                        nonceCache = this.createNonceCache(req, session);
                    }
                    String newNonce = this.generateNonce(req);
                    nonceCache.add(newNonce);
                    request.setAttribute("org.apache.catalina.filters.CSRF_REQUEST_NONCE", newNonce);
                    wResponse = new CsrfResponseWrapper(res, this.nonceRequestParameterName, newNonce, this.noNoncePredicates);
                }
            }
        }
        chain.doFilter(request, wResponse == null ? response : wResponse);
    }

    protected boolean enforce(HttpServletRequest req, String requestedPath) {
        return this.isEnforce();
    }

    protected boolean skipNonceCheck(HttpServletRequest request) {
        if (!"GET".equals(request.getMethod())) {
            return false;
        }
        String requestedPath = this.getRequestedPath(request);
        if (this.entryPoints.contains(requestedPath)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Skipping CSRF nonce-check for GET request to entry point " + requestedPath);
            }
            return true;
        }
        if (null != this.noNoncePredicates && !this.noNoncePredicates.isEmpty()) {
            for (Predicate<String> p : this.noNoncePredicates) {
                if (!p.test(requestedPath)) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Skipping CSRF nonce-check for GET request to no-nonce path " + requestedPath);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean skipNonceGeneration(HttpServletRequest request) {
        return false;
    }

    protected NonceCache<String> createNonceCache(HttpServletRequest request, HttpSession session) {
        LruCache<String> nonceCache = new LruCache<String>(this.nonceCacheSize);
        session.setAttribute("org.apache.catalina.filters.CSRF_NONCE", nonceCache);
        return nonceCache;
    }

    protected NonceCache<String> getNonceCache(HttpServletRequest request, HttpSession session) {
        if (session == null) {
            return null;
        }
        NonceCache nonceCache = (NonceCache)session.getAttribute("org.apache.catalina.filters.CSRF_NONCE");
        return nonceCache;
    }

    protected static class PatternPredicate
    implements Predicate<String> {
        private final Pattern pattern;

        public PatternPredicate(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean test(String t) {
            return this.pattern.matcher(t).matches();
        }
    }

    protected static class MimePredicate
    implements Predicate<String> {
        private final ServletContext context;
        private final Predicate<String> predicate;

        public MimePredicate(ServletContext context, Predicate<String> predicate) {
            this.context = context;
            this.predicate = predicate;
        }

        @Override
        public boolean test(String t) {
            String mimeType = this.context.getMimeType(t);
            if (mimeType == null) {
                return false;
            }
            return this.predicate.test(mimeType);
        }

        public Predicate<String> getPredicate() {
            return this.predicate;
        }
    }

    protected static class SuffixPredicate
    implements Predicate<String> {
        private final String suffix;

        public SuffixPredicate(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean test(String t) {
            return t.endsWith(this.suffix);
        }
    }

    protected static class PrefixPredicate
    implements Predicate<String> {
        private final String prefix;

        public PrefixPredicate(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean test(String t) {
            return t.startsWith(this.prefix);
        }
    }

    protected static interface NonceCache<T>
    extends Serializable {
        public void add(T var1);

        public boolean contains(T var1);
    }

    protected static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private final String nonceRequestParameterName;
        private final String nonce;
        private final Collection<Predicate<String>> noNoncePatterns;

        public CsrfResponseWrapper(HttpServletResponse response, String nonceRequestParameterName, String nonce, Collection<Predicate<String>> noNoncePatterns) {
            super(response);
            this.nonceRequestParameterName = nonceRequestParameterName;
            this.nonce = nonce;
            this.noNoncePatterns = noNoncePatterns;
        }

        @Override
        public String encodeRedirectURL(String url) {
            if (this.shouldAddNonce(url)) {
                return this.addNonce(super.encodeRedirectURL(url));
            }
            return url;
        }

        @Override
        public String encodeURL(String url) {
            if (this.shouldAddNonce(url)) {
                return this.addNonce(super.encodeURL(url));
            }
            return url;
        }

        private boolean shouldAddNonce(String url) {
            if (null == this.noNoncePatterns || this.noNoncePatterns.isEmpty()) {
                return true;
            }
            for (Predicate<String> p : this.noNoncePatterns) {
                if (!p.test(url)) continue;
                return false;
            }
            return true;
        }

        private String addNonce(String url) {
            int question;
            if (url == null || this.nonce == null) {
                return url;
            }
            String path = url;
            String query = "";
            String anchor = "";
            int pound = path.indexOf(35);
            if (pound >= 0) {
                anchor = path.substring(pound);
                path = path.substring(0, pound);
            }
            if ((question = path.indexOf(63)) >= 0) {
                query = path.substring(question);
                path = path.substring(0, question);
            }
            StringBuilder sb = new StringBuilder(path);
            if (!query.isEmpty()) {
                sb.append(query);
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append(this.nonceRequestParameterName);
            sb.append('=');
            sb.append(this.nonce);
            sb.append(anchor);
            return sb.toString();
        }
    }

    protected static class LruCache<T>
    implements NonceCache<T> {
        private static final long serialVersionUID = 1L;
        private final Map<T, T> cache;

        public LruCache(final int cacheSize) {
            this.cache = new LinkedHashMap<T, T>(this){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ LruCache this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<T, T> eldest) {
                    return this.size() > cacheSize;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(T key) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                this.cache.put(key, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(T key) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                return this.cache.containsKey(key);
            }
        }
    }
}

